/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.zza;
import com.google.android.gms.internal.zzku;
import com.google.android.gms.internal.zzlf;
import com.google.android.gms.internal.zzlv;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zzabB = new Object();
    private static HashSet<Uri> zzabC = new HashSet();
    private static ImageManager zzabD;
    private static ImageManager zzabE;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zzabF;
    private final zzb zzabG;
    private final zzku zzabH;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> zzabI;
    private final Map<Uri, ImageReceiver> zzabJ;
    private final Map<Uri, Long> zzabK;

    public static ImageManager create(Context context) {
        return ImageManager.zzb(context, false);
    }

    public static ImageManager zzb(Context context, boolean bl) {
        if (bl) {
            if (zzabE == null) {
                zzabE = new ImageManager(context, true);
            }
            return zzabE;
        }
        if (zzabD == null) {
            zzabD = new ImageManager(context, false);
        }
        return zzabD;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzabF = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.zzabG = new zzb(this.mContext);
            if (zzlv.zzpR()) {
                this.zznZ();
            }
        } else {
            this.zzabG = null;
        }
        this.zzabH = new zzku();
        this.zzabI = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.zzabJ = new HashMap<Uri, ImageReceiver>();
        this.zzabK = new HashMap<Uri, Long>();
    }

    private void zznZ() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new zze(this.zzabG));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, int resId) {
        zza.zzb zzb2 = new zza.zzb(imageView, resId);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        zzb2.zzbt(defaultResId);
        this.zza(zzb2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        zza.zzc zzc2 = new zza.zzc(listener, uri);
        this.zza(zzc2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        zza.zzc zzc2 = new zza.zzc(listener, uri);
        zzc2.zzbt(defaultResId);
        this.zza(zzc2);
    }

    public void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzb.zzch("ImageManager.loadImage() must be called in the main thread");
        zzd zzd2 = new zzd(zza2);
        zzd2.run();
    }

    private Bitmap zza(zza.zza zza2) {
        if (this.zzabG == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.zzabG.get(zza2);
        return bitmap;
    }

    private static final class zza {
        static int zza(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class zzb
    extends zzlf<zza.zza, Bitmap> {
        public zzb(Context context) {
            super(zzb.zzai(context));
        }

        protected void zza(boolean bl, zza.zza zza2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl, zza2, bitmap, bitmap2);
        }

        private static int zzai(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n = bl && zzlv.zzpO() ? zza.zza(activityManager) : activityManager.getMemoryClass();
            int n2 = 0x100000 * n;
            return (int)(0.33f * (float)n2);
        }

        protected int zza(zza.zza zza2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.zza((zza.zza)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.zza(x0, (zza.zza)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class zze
    implements ComponentCallbacks2 {
        private final zzb zzabG;

        public zze(zzb zzb2) {
            this.zzabG = zzb2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.zzabG.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.zzabG.evictAll();
            } else if (level >= 20) {
                this.zzabG.trimToSize(this.zzabG.size() / 2);
            }
        }
    }

    private final class zzf
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zzoR;
        private boolean zzabP;

        public zzf(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.zzabP = bl;
            this.zzoR = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzb.zzch("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.zzabG != null) {
                if (this.zzabP) {
                    ImageManager.this.zzabG.evictAll();
                    System.gc();
                    this.zzabP = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.zzabG.put(new zza.zza(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzabJ.remove(this.mUri))) != null) {
                this.zza(imageReceiver, bl);
            }
            this.zzoR.countDown();
            Object object = zzabB;
            synchronized (object) {
                zzabC.remove(this.mUri);
            }
        }

        private void zza(ImageReceiver imageReceiver, boolean bl) {
            ArrayList arrayList = imageReceiver.zzabL;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                if (bl) {
                    zza2.zza(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.zzabK.put(this.mUri, SystemClock.elapsedRealtime());
                    zza2.zza(ImageManager.this.mContext, ImageManager.this.zzabH, false);
                }
                if (zza2 instanceof zza.zzc) continue;
                ImageManager.this.zzabI.remove(zza2);
            }
        }
    }

    private final class zzc
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor zzabN;

        public zzc(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.zzabN = parcelFileDescriptor;
        }

        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzci("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zzabN != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zzabN.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zzabN.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zzf(this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zza> zzabL;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.zzabL = new ArrayList();
        }

        public void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzch("ImageReceiver.addImageRequest() must be called in the main thread");
            this.zzabL.add(zza2);
        }

        public void zzc(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzch("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zzabL.remove(zza2);
        }

        public void zzoc() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zzabF.execute(new zzc(this.mUri, parcelFileDescriptor));
        }
    }

    private final class zzd
    implements Runnable {
        private final com.google.android.gms.common.images.zza zzabO;

        public zzd(com.google.android.gms.common.images.zza zza2) {
            this.zzabO = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzch("LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzabI.get(this.zzabO));
            if (imageReceiver != null) {
                ImageManager.this.zzabI.remove(this.zzabO);
                imageReceiver.zzc(this.zzabO);
            }
            zza.zza zza2 = this.zzabO.zzabQ;
            if (zza2.uri == null) {
                this.zzabO.zza(ImageManager.this.mContext, ImageManager.this.zzabH, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zza(zza2);
            if (bitmap != null) {
                this.zzabO.zza(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zzabK.get(zza2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zzabO.zza(ImageManager.this.mContext, ImageManager.this.zzabH, true);
                    return;
                }
                ImageManager.this.zzabK.remove(zza2.uri);
            }
            this.zzabO.zza(ImageManager.this.mContext, ImageManager.this.zzabH);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzabJ.get(zza2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zza2.uri);
                ImageManager.this.zzabJ.put(zza2.uri, imageReceiver);
            }
            imageReceiver.zzb(this.zzabO);
            if (!(this.zzabO instanceof zza.zzc)) {
                ImageManager.this.zzabI.put(this.zzabO, imageReceiver);
            }
            Object object = zzabB;
            synchronized (object) {
                boolean bl = zzabC.contains(zza2.uri);
                if (!bl) {
                    zzabC.add(zza2.uri);
                    imageReceiver.zzoc();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

