/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.api.zzj;
import com.google.android.gms.common.api.zzk;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.signin.internal.AuthAccountResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzg
implements zzj {
    private final com.google.android.gms.common.api.zzi zzZq;
    private final Lock zzZs;
    private final Context mContext;
    private final GoogleApiAvailability zzZi;
    private ConnectionResult zzZt;
    private int zzZu;
    private int zzZv = 0;
    private boolean zzZw = false;
    private int zzZx;
    private final Bundle zzZy = new Bundle();
    private final Set<Api.zzc> zzZz = new HashSet<Api.zzc>();
    private com.google.android.gms.signin.zzd zzZA;
    private int zzZB;
    private boolean zzZC;
    private boolean zzZD;
    private zzp zzZE;
    private boolean zzZF;
    private boolean zzZG;
    private final com.google.android.gms.common.internal.zzf zzZH;
    private final Map<Api<?>, Integer> zzZI;
    private final Api.zza<? extends com.google.android.gms.signin.zzd, com.google.android.gms.signin.zze> zzZj;
    private ArrayList<Future<?>> zzZJ = new ArrayList();

    public zzg(com.google.android.gms.common.api.zzi zzi2, com.google.android.gms.common.internal.zzf zzf2, Map<Api<?>, Integer> map, GoogleApiAvailability googleApiAvailability, Api.zza<? extends com.google.android.gms.signin.zzd, com.google.android.gms.signin.zze> zza2, Lock lock, Context context) {
        this.zzZq = zzi2;
        this.zzZH = zzf2;
        this.zzZI = map;
        this.zzZi = googleApiAvailability;
        this.zzZj = zza2;
        this.zzZs = lock;
        this.mContext = context;
    }

    @Override
    public String getName() {
        return "CONNECTING";
    }

    @Override
    public void begin() {
        this.zzZq.zzZY.zzoJ();
        this.zzZq.zzaag.clear();
        this.zzZw = false;
        this.zzZC = false;
        this.zzZt = null;
        this.zzZv = 0;
        this.zzZB = 2;
        this.zzZD = false;
        this.zzZF = false;
        boolean bl = false;
        HashMap<Api.zzb, GoogleApiClient.zza> hashMap = new HashMap<Api.zzb, GoogleApiClient.zza>();
        for (Api<?> api : this.zzZI.keySet()) {
            Api.zzb zzb2 = this.zzZq.zzaaf.get(api.zznd());
            int n = this.zzZI.get(api);
            bl |= api.zznb().getPriority() == 1;
            if (zzb2.zzlm()) {
                this.zzZC = true;
                if (n < this.zzZB) {
                    this.zzZB = n;
                }
                if (n != 0) {
                    this.zzZz.add(api.zznd());
                }
            }
            hashMap.put(zzb2, new zzd(this, api, n));
        }
        if (bl) {
            this.zzZC = false;
        }
        if (this.zzZC) {
            this.zzZH.zza(this.zzZq.getSessionId());
            zzg zzg2 = new zzg();
            this.zzZA = this.zzZj.zza(this.mContext, this.zzZq.getLooper(), this.zzZH, this.zzZH.zzoo(), zzg2, zzg2);
        }
        this.zzZx = this.zzZq.zzaaf.size();
        this.zzZJ.add(zzk.zznF().submit(new zze(hashMap)));
    }

    private boolean zzno() {
        --this.zzZx;
        if (this.zzZx > 0) {
            return false;
        }
        if (this.zzZx < 0) {
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.");
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        if (this.zzZt != null) {
            this.zzf(this.zzZt);
            return false;
        }
        return true;
    }

    private void zznp() {
        if (this.zzZx != 0) {
            return;
        }
        if (this.zzZC) {
            if (this.zzZD) {
                this.zznq();
            }
        } else {
            this.zzns();
        }
    }

    private void zza(ResolveAccountResponse resolveAccountResponse) {
        if (!this.zzbe(0)) {
            return;
        }
        ConnectionResult connectionResult = resolveAccountResponse.zzoP();
        if (connectionResult.isSuccess()) {
            this.zzZE = resolveAccountResponse.zzoO();
            this.zzZD = true;
            this.zzZF = resolveAccountResponse.zzoQ();
            this.zzZG = resolveAccountResponse.zzoR();
            this.zznp();
        } else if (this.zze(connectionResult)) {
            this.zznu();
            this.zznp();
        } else {
            this.zzf(connectionResult);
        }
    }

    private void zznq() {
        ArrayList<Api.zzb> arrayList = new ArrayList<Api.zzb>();
        this.zzZv = 1;
        this.zzZx = this.zzZq.zzaaf.size();
        for (Api.zzc<?> zzc2 : this.zzZq.zzaaf.keySet()) {
            if (this.zzZq.zzaag.containsKey(zzc2)) {
                if (!this.zzno()) continue;
                this.zznr();
                continue;
            }
            arrayList.add(this.zzZq.zzaaf.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zzZJ.add(zzk.zznF().submit(new zzh(arrayList)));
        }
    }

    private void zznr() {
        this.zzZv = 2;
        this.zzZq.zzaah = this.zznw();
        this.zzZJ.add(zzk.zznF().submit(new zzc()));
    }

    private void zzc(ConnectionResult connectionResult) {
        if (!this.zzbe(2)) {
            return;
        }
        if (connectionResult.isSuccess()) {
            this.zzns();
        } else if (this.zze(connectionResult)) {
            this.zznu();
            this.zzns();
        } else {
            this.zzf(connectionResult);
        }
    }

    private void zzns() {
        ArrayList<Api.zzb> arrayList = new ArrayList<Api.zzb>();
        this.zzZv = 3;
        this.zzZx = this.zzZq.zzaaf.size();
        for (Api.zzc<?> zzc2 : this.zzZq.zzaaf.keySet()) {
            if (this.zzZq.zzaag.containsKey(zzc2)) {
                if (!this.zzno()) continue;
                this.zznt();
                continue;
            }
            arrayList.add(this.zzZq.zzaaf.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zzZJ.add(zzk.zznF().submit(new zzf(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (!this.zzbe(3)) {
            return;
        }
        if (connectionHint != null) {
            this.zzZy.putAll(connectionHint);
        }
        if (this.zzno()) {
            this.zznt();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzbe(3)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzno()) {
            this.zznt();
        }
    }

    private void zznt() {
        this.zzZq.zznA();
        zzk.zznF().execute(new Runnable(){

            @Override
            public void run() {
                zzg.this.zzZi.zzac(zzg.this.mContext);
            }
        });
        if (this.zzZA != null) {
            if (this.zzZF) {
                this.zzZA.zza(this.zzZE, this.zzZG);
            }
            this.zzX(false);
        }
        for (Api.zzc<?> zzc2 : this.zzZq.zzaag.keySet()) {
            Api.zzb zzb2 = this.zzZq.zzaaf.get(zzc2);
            zzb2.disconnect();
        }
        if (this.zzZw) {
            this.zzZw = false;
            this.disconnect();
        } else {
            Bundle bundle = this.zzZy.isEmpty() ? null : this.zzZy;
            this.zzZq.zzZY.zzh(bundle);
        }
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzc.zza<R, A>> T zza(T t) {
        this.zzZq.zzZZ.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zzc.zza<? extends Result, A>> T zzb(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
        this.zzZw = false;
    }

    @Override
    public void disconnect() {
        Iterator iterator = this.zzZq.zzZZ.iterator();
        while (iterator.hasNext()) {
            zzi.zze zze2 = (zzi.zze)iterator.next();
            if (zze2.zzng() == 1) continue;
            zze2.cancel();
            iterator.remove();
        }
        this.zzZq.zznx();
        if (this.zzZt == null && !this.zzZq.zzZZ.isEmpty()) {
            this.zzZw = true;
            return;
        }
        this.zznv();
        this.zzX(true);
        this.zzZq.zzaag.clear();
        this.zzZq.zzg(null);
        this.zzZq.zzZY.zzoI();
    }

    @Override
    public void onConnectionSuspended(int cause) {
        this.zzf(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zznb().getPriority(), n, connectionResult)) {
            this.zzZt = connectionResult;
            this.zzZu = n2;
        }
        this.zzZq.zzaag.put(api.zznd(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !this.zzd(connectionResult)) {
            return false;
        }
        return this.zzZt == null || n < this.zzZu;
    }

    private boolean zzd(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.zzZi.zzbb(connectionResult.getErrorCode()) != null;
    }

    private void zznu() {
        this.zzZC = false;
        this.zzZq.zzaah = Collections.emptySet();
        for (Api.zzc zzc2 : this.zzZz) {
            if (this.zzZq.zzaag.containsKey(zzc2)) continue;
            this.zzZq.zzaag.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zze(ConnectionResult connectionResult) {
        return this.zzZB == 2 || this.zzZB == 1 && !connectionResult.hasResolution();
    }

    private void zzf(ConnectionResult connectionResult) {
        this.zzZw = false;
        this.zznv();
        this.zzX(!connectionResult.hasResolution());
        this.zzZq.zzaag.clear();
        this.zzZq.zzg(connectionResult);
        if (!this.zzZq.zznB() || !this.zzZi.zzd(this.mContext, connectionResult.getErrorCode())) {
            this.zzZq.zznE();
            this.zzZq.zzZY.zzj(connectionResult);
        }
        this.zzZq.zzZY.zzoI();
    }

    private void zzX(boolean bl) {
        if (this.zzZA != null) {
            if (this.zzZA.isConnected() && bl) {
                this.zzZA.zzzn();
            }
            this.zzZA.disconnect();
            this.zzZE = null;
        }
    }

    private void zznv() {
        for (Future<?> future : this.zzZJ) {
            future.cancel(true);
        }
        this.zzZJ.clear();
    }

    private Set<Scope> zznw() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzZH.zzoi());
        Map<Api<?>, zzf.zza> map = this.zzZH.zzok();
        for (Api<?> api : map.keySet()) {
            if (this.zzZq.zzaag.containsKey(api.zznd())) continue;
            hashSet.addAll(map.get(api).zzZp);
        }
        return hashSet;
    }

    private boolean zzbe(int n) {
        if (this.zzZv != n) {
            Log.wtf((String)"GoogleApiClientConnecting", (String)("GoogleApiClient connecting is in step " + this.zzbf(this.zzZv) + " but received callback for step " + this.zzbf(n)));
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzbf(int n) {
        switch (n) {
            case 0: {
                return "STEP_GETTING_SERVICE_BINDINGS";
            }
            case 1: {
                return "STEP_VALIDATING_ACCOUNT";
            }
            case 2: {
                return "STEP_AUTHENTICATING";
            }
            case 3: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zza
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zzg> zzZL;

        zza(zzg zzg2) {
            this.zzZL = new WeakReference<zzg>(zzg2);
        }

        @Override
        public void zza(final ConnectionResult connectionResult, AuthAccountResult authAccountResult) {
            final zzg zzg2 = (zzg)this.zzZL.get();
            if (zzg2 == null) {
                return;
            }
            zzg2.zzZq.zza(new zzi.zzb(zzg2){

                @Override
                public void zznn() {
                    zzg2.zzc(connectionResult);
                }
            });
        }
    }

    private static class zzd
    implements GoogleApiClient.zza {
        private final WeakReference<zzg> zzZL;
        private final Api<?> zzZR;
        private final int zzZS;

        public zzd(zzg zzg2, Api<?> api, int n) {
            this.zzZL = new WeakReference<zzg>(zzg2);
            this.zzZR = api;
            this.zzZS = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ConnectionResult connectionResult) {
            zzg zzg2 = (zzg)this.zzZL.get();
            if (zzg2 == null) {
                return;
            }
            zzx.zza(Looper.myLooper() == zzg2.zzZq.getLooper(), (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzg2.zzZs.lock();
            try {
                if (!zzg2.zzbe(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzg2.zzb(connectionResult, this.zzZR, this.zzZS);
                }
                if (zzg2.zzno()) {
                    zzg2.zznp();
                }
            }
            finally {
                zzg2.zzZs.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzb(ConnectionResult connectionResult) {
            zzg zzg2 = (zzg)this.zzZL.get();
            if (zzg2 == null) {
                return;
            }
            zzx.zza(Looper.myLooper() == zzg2.zzZq.getLooper(), (Object)"onReportAccountValidation must be called on the GoogleApiClient handler thread");
            zzg2.zzZs.lock();
            try {
                if (!zzg2.zzbe(1)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzg2.zzb(connectionResult, this.zzZR, this.zzZS);
                }
                if (zzg2.zzno()) {
                    zzg2.zznr();
                }
            }
            finally {
                zzg2.zzZs.unlock();
            }
        }
    }

    private class zzg
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzg() {
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            zzg.this.zzZA.zza(new zzb(zzg.this));
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionFailed(ConnectionResult result) {
            zzg.this.zzZs.lock();
            try {
                if (zzg.this.zze(result)) {
                    zzg.this.zznu();
                    zzg.this.zzns();
                } else {
                    zzg.this.zzf(result);
                }
            }
            finally {
                zzg.this.zzZs.unlock();
            }
        }
    }

    private static class zzb
    extends zzt.zza {
        private final WeakReference<zzg> zzZL;

        zzb(zzg zzg2) {
            this.zzZL = new WeakReference<zzg>(zzg2);
        }

        @Override
        public void zzb(final ResolveAccountResponse resolveAccountResponse) {
            final zzg zzg2 = (zzg)this.zzZL.get();
            if (zzg2 == null) {
                return;
            }
            zzg2.zzZq.zza(new zzi.zzb(zzg2){

                @Override
                public void zznn() {
                    zzg2.zza(resolveAccountResponse);
                }
            });
        }
    }

    private class zzf
    extends zzi {
        private final ArrayList<Api.zzb> zzZW;

        public zzf(ArrayList<Api.zzb> arrayList) {
            this.zzZW = arrayList;
        }

        @Override
        public void zznn() {
            Set set = ((zzg)zzg.this).zzZq.zzaah;
            if (set.isEmpty()) {
                set = zzg.this.zznw();
            }
            for (Api.zzb zzb2 : this.zzZW) {
                zzb2.zza(zzg.this.zzZE, set);
            }
        }
    }

    private class zzc
    extends zzi {
        private zzc() {
        }

        @Override
        public void zznn() {
            zzg.this.zzZA.zza(zzg.this.zzZE, ((zzg)zzg.this).zzZq.zzaah, new zza(zzg.this));
        }
    }

    private class zzh
    extends zzi {
        private final ArrayList<Api.zzb> zzZW;

        public zzh(ArrayList<Api.zzb> arrayList) {
            this.zzZW = arrayList;
        }

        @Override
        public void zznn() {
            for (Api.zzb zzb2 : this.zzZW) {
                zzb2.zza(zzg.this.zzZE);
            }
        }
    }

    private class zze
    extends zzi {
        private final Map<Api.zzb, GoogleApiClient.zza> zzZT;

        public zze(Map<Api.zzb, GoogleApiClient.zza> map) {
            this.zzZT = map;
        }

        @Override
        public void zznn() {
            int n = zzg.this.zzZi.isGooglePlayServicesAvailable(zzg.this.mContext);
            if (n != 0) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzg.this.zzZq.zza(new zzi.zzb(zzg.this){

                    @Override
                    public void zznn() {
                        zzg.this.zzf(connectionResult);
                    }
                });
                return;
            }
            if (zzg.this.zzZC) {
                zzg.this.zzZA.connect();
            }
            for (Api.zzb zzb2 : this.zzZT.keySet()) {
                zzb2.zza(this.zzZT.get(zzb2));
            }
        }
    }

    private abstract class zzi
    implements Runnable {
        private zzi() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            zzg.this.zzZs.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zznn();
            }
            catch (RuntimeException runtimeException) {
                zzg.this.zzZq.zza(runtimeException);
            }
            finally {
                zzg.this.zzZs.unlock();
            }
        }

        protected abstract void zznn();
    }
}

