/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzn;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;

public final class Status
implements Result,
SafeParcelable {
    public static final Status zzaaD = new Status(0);
    public static final Status zzaaE = new Status(14);
    public static final Status zzaaF = new Status(8);
    public static final Status zzaaG = new Status(15);
    public static final Status zzaaH = new Status(16);
    public static final Parcelable.Creator<Status> CREATOR = new zzn();
    private final int mVersionCode;
    private final int zzWu;
    private final String zzaaI;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.mVersionCode = versionCode;
        this.zzWu = statusCode;
        this.zzaaI = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(1, statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent zznH() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.zzaaI;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzWu <= 0;
    }

    public boolean isCanceled() {
        return this.zzWu == 16;
    }

    public boolean isInterrupted() {
        return this.zzWu == 14;
    }

    public int getStatusCode() {
        return this.zzWu;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzw.hashCode(this.mVersionCode, this.zzWu, this.zzaaI, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.mVersionCode == status.mVersionCode && this.zzWu == status.zzWu && zzw.equal(this.zzaaI, status.zzaaI) && zzw.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zznI() {
        if (this.zzaaI != null) {
            return this.zzaaI;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzWu);
    }

    public String toString() {
        return zzw.zzu(this).zzg("statusCode", this.zznI()).zzg("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzn.zza(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

