/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames zzarQ;
    private final PlayerLevelInfo zzarG;
    private final MostRecentGameInfoRef zzarR;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.zzarQ = new PlayerColumnNames(prefix);
        this.zzarR = new MostRecentGameInfoRef(holder, dataRow, this.zzarQ);
        if (this.zzsU()) {
            PlayerLevel playerLevel;
            int n = this.getInteger(this.zzarQ.zzaxb);
            int n2 = this.getInteger(this.zzarQ.zzaxe);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n, this.getLong(this.zzarQ.zzaxc), this.getLong(this.zzarQ.zzaxd));
            if (n != n2) {
                playerLevel2 = new PlayerLevel(n2, this.getLong(this.zzarQ.zzaxd), this.getLong(this.zzarQ.zzaxf));
            }
            this.zzarG = new PlayerLevelInfo(this.getLong(this.zzarQ.zzaxa), this.getLong(this.zzarQ.zzaxg), playerLevel, playerLevel2);
        } else {
            this.zzarG = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.zzarQ.zzawR);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.zzarQ.zzawS);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.zza(this.zzarQ.zzawS, dataOut);
    }

    @Override
    public boolean zzsR() {
        return this.getBoolean(this.zzarQ.zzaxp);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzce(this.zzarQ.zzawT);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.zzarQ.zzawU);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzce(this.zzarQ.zzawV);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.zzarQ.zzawW);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.zzarQ.zzawX);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzcd(this.zzarQ.zzawZ) || this.zzcf(this.zzarQ.zzawZ)) {
            return -1L;
        }
        return this.getLong(this.zzarQ.zzawZ);
    }

    @Override
    public int zzsS() {
        return this.getInteger(this.zzarQ.zzawY);
    }

    @Override
    public boolean isProfileVisible() {
        return this.getBoolean(this.zzarQ.zzaxi);
    }

    @Override
    public String getTitle() {
        return this.getString(this.zzarQ.title);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.zza(this.zzarQ.title, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzarG;
    }

    @Override
    public MostRecentGameInfo zzsT() {
        if (this.zzcf(this.zzarQ.zzaxj)) {
            return null;
        }
        return this.zzarR;
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean zzsU() {
        if (this.zzcf(this.zzarQ.zzaxa)) {
            return false;
        }
        return this.getLong(this.zzarQ.zzaxa) != -1L;
    }
}

