/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfoCreator;

public final class PlayerLevelInfo
implements SafeParcelable {
    public static final Parcelable.Creator<PlayerLevelInfo> CREATOR = new PlayerLevelInfoCreator();
    private final int mVersionCode;
    private final long zzarM;
    private final long zzarN;
    private final PlayerLevel zzarO;
    private final PlayerLevel zzarP;

    public PlayerLevelInfo(long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        this(1, currentXpTotal, lastLevelUpTimestamp, currentLevel, nextLevel);
    }

    PlayerLevelInfo(int versionCode, long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        zzx.zzY((currentXpTotal != -1L ? 1 : 0) != 0);
        zzx.zzv((Object)currentLevel);
        zzx.zzv((Object)nextLevel);
        this.mVersionCode = versionCode;
        this.zzarM = currentXpTotal;
        this.zzarN = lastLevelUpTimestamp;
        this.zzarO = currentLevel;
        this.zzarP = nextLevel;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public long getCurrentXpTotal() {
        return this.zzarM;
    }

    public long getLastLevelUpTimestamp() {
        return this.zzarN;
    }

    public PlayerLevel getCurrentLevel() {
        return this.zzarO;
    }

    public PlayerLevel getNextLevel() {
        return this.zzarP;
    }

    public boolean isMaxLevel() {
        return this.zzarO.equals(this.zzarP);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevelInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlayerLevelInfo playerLevelInfo = (PlayerLevelInfo)obj;
        return zzw.equal((Object)this.zzarM, (Object)playerLevelInfo.zzarM) && zzw.equal((Object)this.zzarN, (Object)playerLevelInfo.zzarN) && zzw.equal((Object)this.zzarO, (Object)playerLevelInfo.zzarO) && zzw.equal((Object)this.zzarP, (Object)playerLevelInfo.zzarP);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzarM, this.zzarN, this.zzarO, this.zzarP});
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelInfoCreator.zza(this, out, flags);
    }
}

