/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.zzln;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzWn;
    private final String zzahh;
    private final Uri zzaqW;
    private final Uri zzaqX;
    private final long zzarC;
    private final int zzarD;
    private final long zzarE;
    private final String zzarh;
    private final String zzari;
    private final String zzagU;
    private final MostRecentGameInfoEntity zzarF;
    private final PlayerLevelInfo zzarG;
    private final boolean zzarH;
    private final boolean zzarI;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean isPlusEnabled) {
        this.mVersionCode = 12;
        this.zzWn = isPlusEnabled ? player.getPlayerId() : null;
        this.zzahh = player.getDisplayName();
        this.zzaqW = player.getIconImageUri();
        this.zzarh = player.getIconImageUrl();
        this.zzaqX = player.getHiResImageUri();
        this.zzari = player.getHiResImageUrl();
        this.zzarC = player.getRetrievedTimestamp();
        this.zzarD = player.zzsS();
        this.zzarE = player.getLastPlayedWithTimestamp();
        this.zzagU = player.getTitle();
        this.zzarH = player.isProfileVisible();
        MostRecentGameInfo mostRecentGameInfo = player.zzsT();
        this.zzarF = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.zzarG = player.getLevelInfo();
        this.zzarI = player.zzsR();
        if (isPlusEnabled) {
            zzb.zzr((Object)this.zzWn);
        }
        zzb.zzr((Object)this.zzahh);
        zzb.zzY((this.zzarC > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible, boolean hasDebugAccess) {
        this.mVersionCode = versionCode;
        this.zzWn = playerId;
        this.zzahh = displayName;
        this.zzaqW = iconImageUri;
        this.zzarh = iconImageUrl;
        this.zzaqX = hiResImageUri;
        this.zzari = hiResImageUrl;
        this.zzarC = retrievedTimestamp;
        this.zzarD = isInCircles;
        this.zzarE = lastPlayedWithTimestamp;
        this.zzagU = title;
        this.zzarH = isProfileVisible;
        this.zzarF = mostRecentGameInfo;
        this.zzarG = playerLevelInfo;
        this.zzarI = hasDebugAccess;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getPlayerId() {
        return this.zzWn;
    }

    @Override
    public String getDisplayName() {
        return this.zzahh;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzahh, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean zzsR() {
        return this.zzarI;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaqW;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzarh;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzaqX;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzari;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zzarC;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzarE;
    }

    @Override
    public int zzsS() {
        return this.zzarD;
    }

    @Override
    public boolean isProfileVisible() {
        return this.zzarH;
    }

    @Override
    public String getTitle() {
        return this.zzagU;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzagU, (CharArrayBuffer)dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzarG;
    }

    @Override
    public MostRecentGameInfo zzsT() {
        return this.zzarF;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzw.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzsR(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo()});
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzw.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzw.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzw.equal((Object)player2.zzsR(), (Object)player.zzsR()) && zzw.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzw.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzw.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzw.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzw.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzw.zzu((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzsR()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzos()) {
            PlayerEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzWn);
            dest.writeString(this.zzahh);
            dest.writeString(this.zzaqW == null ? null : this.zzaqW.toString());
            dest.writeString(this.zzaqX == null ? null : this.zzaqX.toString());
            dest.writeLong(this.zzarC);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzdD(Parcel parcel) {
            boolean bl = PlayerEntity.zzd(PlayerEntity.zzor());
            if (bl || PlayerEntity.zzcj((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzdD(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            int n = -1;
            long l2 = -1L;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl2 = true;
            boolean bl3 = false;
            return new PlayerEntity(12, string, string2, uri, uri2, l, n, l2, string5, string6, string7, mostRecentGameInfoEntity, playerLevelInfo, bl2, bl3);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdD(x0);
        }
    }
}

