/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.zzln;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzSX;
    private final String zzahh;
    private final String zzaqT;
    private final String zzaqU;
    private final String zzaoB;
    private final String zzaqV;
    private final Uri zzaqW;
    private final Uri zzaqX;
    private final Uri zzaqY;
    private final boolean zzaqZ;
    private final boolean zzara;
    private final String zzarb;
    private final int zzarc;
    private final int zzard;
    private final int zzare;
    private final boolean zzarf;
    private final boolean zzarg;
    private final String zzarh;
    private final String zzari;
    private final String zzarj;
    private final boolean zzAn;
    private final boolean zzark;
    private final boolean zzarl;
    private final String zzarm;
    private final boolean zzarn;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.zzSX = game.getApplicationId();
        this.zzaqT = game.getPrimaryCategory();
        this.zzaqU = game.getSecondaryCategory();
        this.zzaoB = game.getDescription();
        this.zzaqV = game.getDeveloperName();
        this.zzahh = game.getDisplayName();
        this.zzaqW = game.getIconImageUri();
        this.zzarh = game.getIconImageUrl();
        this.zzaqX = game.getHiResImageUri();
        this.zzari = game.getHiResImageUrl();
        this.zzaqY = game.getFeaturedImageUri();
        this.zzarj = game.getFeaturedImageUrl();
        this.zzaqZ = game.zzsK();
        this.zzara = game.zzsM();
        this.zzarb = game.zzsN();
        this.zzarc = game.zzsO();
        this.zzard = game.getAchievementTotalCount();
        this.zzare = game.getLeaderboardCount();
        this.zzarf = game.isRealTimeMultiplayerEnabled();
        this.zzarg = game.isTurnBasedMultiplayerEnabled();
        this.zzAn = game.isMuted();
        this.zzark = game.zzsL();
        this.zzarl = game.areSnapshotsEnabled();
        this.zzarm = game.getThemeColor();
        this.zzarn = game.hasGamepadSupport();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor, boolean hasGamepadSupport) {
        this.mVersionCode = versionCode;
        this.zzSX = applicationId;
        this.zzahh = displayName;
        this.zzaqT = primaryCategory;
        this.zzaqU = secondaryCategory;
        this.zzaoB = description;
        this.zzaqV = developerName;
        this.zzaqW = iconImageUri;
        this.zzarh = iconImageUrl;
        this.zzaqX = hiResImageUri;
        this.zzari = hiResImageUrl;
        this.zzaqY = featuredImageUri;
        this.zzarj = featuredImageUrl;
        this.zzaqZ = playEnabledGame;
        this.zzara = instanceInstalled;
        this.zzarb = instancePackageName;
        this.zzarc = gameplayAclStatus;
        this.zzard = achievementTotalCount;
        this.zzare = leaderboardCount;
        this.zzarf = realTimeEnabled;
        this.zzarg = turnBasedEnabled;
        this.zzAn = muted;
        this.zzark = identitySharingConfirmed;
        this.zzarl = snapshotsEnabled;
        this.zzarm = themeColor;
        this.zzarn = hasGamepadSupport;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.zzSX;
    }

    @Override
    public String getDisplayName() {
        return this.zzahh;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzahh, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzaqT;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzaqU;
    }

    @Override
    public String getDescription() {
        return this.zzaoB;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzaoB, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.zzaqV;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzaqV, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaqW;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzarh;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzaqX;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzari;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzaqY;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzarj;
    }

    @Override
    public boolean isMuted() {
        return this.zzAn;
    }

    @Override
    public boolean zzsL() {
        return this.zzark;
    }

    @Override
    public boolean zzsK() {
        return this.zzaqZ;
    }

    @Override
    public boolean zzsM() {
        return this.zzara;
    }

    @Override
    public String zzsN() {
        return this.zzarb;
    }

    @Override
    public int zzsO() {
        return this.zzarc;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzard;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzare;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzarf;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzarg;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzarl;
    }

    @Override
    public String getThemeColor() {
        return this.zzarm;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzarn;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzw.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzsK(), game.zzsM(), game.zzsN(), game.zzsO(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzsL(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object obj) {
        return GameEntity.zza(this, obj);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzw.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzw.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzw.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzw.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzw.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzw.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzw.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzw.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzw.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzw.equal((Object)game2.zzsK(), (Object)game.zzsK()) && zzw.equal((Object)game2.zzsM(), (Object)game.zzsM()) && zzw.equal((Object)game2.zzsN(), (Object)game.zzsN()) && zzw.equal((Object)game2.zzsO(), (Object)game.zzsO()) && zzw.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzw.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzw.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzw.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzw.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzw.equal((Object)game2.zzsL(), (Object)game.zzsL()) ? 1 : 0)) && zzw.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzw.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzw.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzw.zzu((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzsK()).zzg("InstanceInstalled", (Object)game.zzsM()).zzg("InstancePackageName", (Object)game.zzsN()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzos()) {
            GameEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzSX);
            dest.writeString(this.zzahh);
            dest.writeString(this.zzaqT);
            dest.writeString(this.zzaqU);
            dest.writeString(this.zzaoB);
            dest.writeString(this.zzaqV);
            dest.writeString(this.zzaqW == null ? null : this.zzaqW.toString());
            dest.writeString(this.zzaqX == null ? null : this.zzaqX.toString());
            dest.writeString(this.zzaqY == null ? null : this.zzaqY.toString());
            dest.writeInt(this.zzaqZ ? 1 : 0);
            dest.writeInt(this.zzara ? 1 : 0);
            dest.writeString(this.zzarb);
            dest.writeInt(this.zzarc);
            dest.writeInt(this.zzard);
            dest.writeInt(this.zzare);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzdC(Parcel parcel) {
            boolean bl = GameEntity.zzd(GameEntity.zzor());
            if (bl || GameEntity.zzcj((String)GameEntity.class.getCanonicalName())) {
                return super.zzdC(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            String string14 = null;
            boolean bl9 = false;
            return new GameEntity(7, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, bl4, bl5, string11, string12, string13, bl6, bl7, bl8, string14, bl9);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdC(x0);
        }
    }
}

