/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.media;

import android.content.Context;
import android.os.Build;
import android.support.v7.media.MediaRouterJellybean;
import java.lang.ref.WeakReference;

abstract class RemoteControlClientCompat {
    protected final Context mContext;
    protected final Object mRcc;
    protected VolumeCallback mVolumeCallback;

    protected RemoteControlClientCompat(Context context, Object rcc) {
        this.mContext = context;
        this.mRcc = rcc;
    }

    public static RemoteControlClientCompat obtain(Context context, Object rcc) {
        if (Build.VERSION.SDK_INT >= 16) {
            return new JellybeanImpl(context, rcc);
        }
        return new LegacyImpl(context, rcc);
    }

    public Object getRemoteControlClient() {
        return this.mRcc;
    }

    public void setPlaybackInfo(PlaybackInfo info) {
    }

    public void setVolumeCallback(VolumeCallback callback) {
        this.mVolumeCallback = callback;
    }

    static class JellybeanImpl
    extends RemoteControlClientCompat {
        private final Object mRouterObj;
        private final Object mUserRouteCategoryObj;
        private final Object mUserRouteObj;
        private boolean mRegistered;

        public JellybeanImpl(Context context, Object rcc) {
            super(context, rcc);
            this.mRouterObj = MediaRouterJellybean.getMediaRouter((Context)context);
            this.mUserRouteCategoryObj = MediaRouterJellybean.createRouteCategory((Object)this.mRouterObj, (String)"", (boolean)false);
            this.mUserRouteObj = MediaRouterJellybean.createUserRoute((Object)this.mRouterObj, (Object)this.mUserRouteCategoryObj);
        }

        @Override
        public void setPlaybackInfo(PlaybackInfo info) {
            MediaRouterJellybean.UserRouteInfo.setVolume((Object)this.mUserRouteObj, (int)info.volume);
            MediaRouterJellybean.UserRouteInfo.setVolumeMax((Object)this.mUserRouteObj, (int)info.volumeMax);
            MediaRouterJellybean.UserRouteInfo.setVolumeHandling((Object)this.mUserRouteObj, (int)info.volumeHandling);
            MediaRouterJellybean.UserRouteInfo.setPlaybackStream((Object)this.mUserRouteObj, (int)info.playbackStream);
            MediaRouterJellybean.UserRouteInfo.setPlaybackType((Object)this.mUserRouteObj, (int)info.playbackType);
            if (!this.mRegistered) {
                this.mRegistered = true;
                MediaRouterJellybean.UserRouteInfo.setVolumeCallback((Object)this.mUserRouteObj, (Object)MediaRouterJellybean.createVolumeCallback((MediaRouterJellybean.VolumeCallback)new VolumeCallbackWrapper(this)));
                MediaRouterJellybean.UserRouteInfo.setRemoteControlClient((Object)this.mUserRouteObj, (Object)this.mRcc);
            }
        }

        private static final class VolumeCallbackWrapper
        implements MediaRouterJellybean.VolumeCallback {
            private final WeakReference<JellybeanImpl> mImplWeak;

            public VolumeCallbackWrapper(JellybeanImpl impl) {
                this.mImplWeak = new WeakReference<JellybeanImpl>(impl);
            }

            public void onVolumeUpdateRequest(Object routeObj, int direction) {
                JellybeanImpl impl = (JellybeanImpl)this.mImplWeak.get();
                if (impl != null && impl.mVolumeCallback != null) {
                    impl.mVolumeCallback.onVolumeUpdateRequest(direction);
                }
            }

            public void onVolumeSetRequest(Object routeObj, int volume) {
                JellybeanImpl impl = (JellybeanImpl)this.mImplWeak.get();
                if (impl != null && impl.mVolumeCallback != null) {
                    impl.mVolumeCallback.onVolumeSetRequest(volume);
                }
            }
        }
    }

    static class LegacyImpl
    extends RemoteControlClientCompat {
        public LegacyImpl(Context context, Object rcc) {
            super(context, rcc);
        }
    }

    public static interface VolumeCallback {
        public void onVolumeUpdateRequest(int var1);

        public void onVolumeSetRequest(int var1);
    }

    public static final class PlaybackInfo {
        public int volume;
        public int volumeMax;
        public int volumeHandling = 0;
        public int playbackStream = 3;
        public int playbackType = 1;
    }
}

