/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class LocationSettingsRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<LocationRequest> zzaqn;
    private final boolean zzaCd;
    private final boolean zzaCe;
    private final boolean zzaCf;
    public static final Parcelable.Creator<LocationSettingsRequest> CREATOR = new zzf();

    LocationSettingsRequest(int version, List<LocationRequest> locationRequests, boolean alwaysShow, boolean needBle, boolean optInUserLocationReporting) {
        this.mVersionCode = version;
        this.zzaqn = locationRequests;
        this.zzaCd = alwaysShow;
        this.zzaCe = needBle;
        this.zzaCf = optInUserLocationReporting;
    }

    private LocationSettingsRequest(List<LocationRequest> locationRequests, boolean alwaysShow, boolean needBle, boolean optInUserLocationReporting) {
        this(2, locationRequests, alwaysShow, needBle, optInUserLocationReporting);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public List<LocationRequest> zzsr() {
        return Collections.unmodifiableList(this.zzaqn);
    }

    public boolean zzvJ() {
        return this.zzaCd;
    }

    public boolean zzvK() {
        return this.zzaCe;
    }

    public boolean zzvL() {
        return this.zzaCf;
    }

    public static final class Builder {
        private final ArrayList<LocationRequest> zzaCg = new ArrayList();
        private boolean zzaCd = false;
        private boolean zzaCe = false;
        private boolean zzaCf = false;

        public Builder addLocationRequest(LocationRequest request) {
            this.zzaCg.add(request);
            return this;
        }

        public Builder addAllLocationRequests(Collection<LocationRequest> requests) {
            this.zzaCg.addAll(requests);
            return this;
        }

        public Builder setAlwaysShow(boolean show) {
            this.zzaCd = show;
            return this;
        }

        public Builder setNeedBle(boolean needBle) {
            this.zzaCe = needBle;
            return this;
        }

        public LocationSettingsRequest build() {
            return new LocationSettingsRequest(this.zzaCg, this.zzaCd, this.zzaCe, this.zzaCf);
        }
    }
}

