/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.dynamic.zzh;
import com.google.android.gms.internal.zzra;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzri;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzaXM;
    private boolean mCreated = false;
    private final zzh zzaXN = zzh.zza((Fragment)this);
    private final zzc zzaXO = new zzc();
    private zza zzaXP = new zza(this);
    private final Fragment zzadh = this;
    private WalletFragmentOptions zzaXQ;
    private WalletFragmentInitParams zzaXR;
    private MaskedWalletRequest zzaXS;
    private MaskedWallet zzaXT;
    private Boolean zzaXU;

    public static SupportWalletFragment newInstance(WalletFragmentOptions options) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        supportWalletFragment.zzadh.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.zzaXM != null) {
            this.zzaXM.initialize(initParams);
            this.zzaXR = null;
        } else if (this.zzaXR == null) {
            this.zzaXR = initParams;
            if (this.zzaXS != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzaXT != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.zzaXM != null) {
            this.zzaXM.updateMaskedWalletRequest(request);
            this.zzaXS = null;
        } else {
            this.zzaXS = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzaXM != null) {
            this.zzaXM.updateMaskedWallet(maskedWallet);
            this.zzaXT = null;
        } else {
            this.zzaXT = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.zzaXM != null) {
            this.zzaXM.setEnabled(enabled);
            this.zzaXU = null;
        } else {
            this.zzaXU = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.zzaXP.zza(listener);
    }

    public int getState() {
        return this.zzaXM != null ? this.zzaXM.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.zzaXQ == null) {
            this.zzaXQ = WalletFragmentOptions.zza((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzaXQ);
        this.zzaXO.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzaXR != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzaXR = walletFragmentInitParams;
            }
            if (this.zzaXS == null) {
                this.zzaXS = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.zzaXT == null) {
                this.zzaXT = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.zzaXQ = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.zzaXU = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.zzadh.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzadh.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzaS((Context)this.zzadh.getActivity());
            this.zzaXQ = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzaXO.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.zzaXO.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.zzaXO.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzaXO.onResume();
        FragmentManager fragmentManager = this.zzadh.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzadh.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzadh.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzaXO.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzaXO.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzaXO.onSaveInstanceState(outState);
        if (this.zzaXR != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.zzaXR);
            this.zzaXR = null;
        }
        if (this.zzaXS != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.zzaXS);
            this.zzaXS = null;
        }
        if (this.zzaXT != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.zzaXT);
            this.zzaXT = null;
        }
        if (this.zzaXQ != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.zzaXQ);
            this.zzaXQ = null;
        }
        if (this.zzaXU != null) {
            outState.putBoolean("enabled", this.zzaXU.booleanValue());
            this.zzaXU = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.zzaXM != null) {
            this.zzaXM.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzrb.zza {
        private OnStateChangedListener zzaXV;
        private final SupportWalletFragment zzaXW;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzaXW = supportWalletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzaXV != null) {
                this.zzaXV.onStateChanged(this.zzaXW, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzaXV = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzra zzaXX;

        private zzb(zzra zzra2) {
            this.zzaXX = zzra2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.zzaXX.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.zzaXX.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.zzaXX.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzaXX.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzaXX.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzaXX.zza(zze.zzx((Object)activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaXX.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                zzd zzd2 = this.zzaXX.onCreateView(zze.zzx((Object)inflater), zze.zzx((Object)container), savedInstanceState);
                return (View)zze.zzp((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzaXX.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzaXX.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaXX.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzaXX.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaXX.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.zzaXX.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzadh.getActivity();
            if (SupportWalletFragment.this.zzaXM == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    zzra zzra2 = zzri.zza((Activity)fragmentActivity, (com.google.android.gms.dynamic.zzc)SupportWalletFragment.this.zzaXN, SupportWalletFragment.this.zzaXQ, SupportWalletFragment.this.zzaXP);
                    SupportWalletFragment.this.zzaXM = new zzb(zzra2);
                    SupportWalletFragment.this.zzaXQ = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)SupportWalletFragment.this.zzaXM);
                if (SupportWalletFragment.this.zzaXR != null) {
                    SupportWalletFragment.this.zzaXM.initialize(SupportWalletFragment.this.zzaXR);
                    SupportWalletFragment.this.zzaXR = null;
                }
                if (SupportWalletFragment.this.zzaXS != null) {
                    SupportWalletFragment.this.zzaXM.updateMaskedWalletRequest(SupportWalletFragment.this.zzaXS);
                    SupportWalletFragment.this.zzaXS = null;
                }
                if (SupportWalletFragment.this.zzaXT != null) {
                    SupportWalletFragment.this.zzaXM.updateMaskedWallet(SupportWalletFragment.this.zzaXT);
                    SupportWalletFragment.this.zzaXT = null;
                }
                if (SupportWalletFragment.this.zzaXU != null) {
                    SupportWalletFragment.this.zzaXM.setEnabled(SupportWalletFragment.this.zzaXU);
                    SupportWalletFragment.this.zzaXU = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.zzadh.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (SupportWalletFragment.this.zzaXQ != null && (walletFragmentStyle = SupportWalletFragment.this.zzaXQ.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.zzadh.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, n);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, n2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzadh.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)fragmentActivity, (int)-1);
        }
    }
}

