/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.internal.PlaceLocalization;
import com.google.android.gms.location.places.internal.zzk;
import com.google.android.gms.location.places.internal.zzo;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class PlaceImpl
implements SafeParcelable,
Place {
    public static final zzk CREATOR = new zzk();
    final int mVersionCode;
    private final String zzwj;
    private final Bundle zzaEq;
    @Deprecated
    private final PlaceLocalization zzaEr;
    private final LatLng zzaDh;
    private final float zzaEs;
    private final LatLngBounds zzaEt;
    private final String zzaEu;
    private final Uri zzaDk;
    private final boolean zzaEv;
    private final float zzaEw;
    private final int zzaEx;
    private final long zzaEy;
    private final List<Integer> zzaEz;
    private final List<Integer> zzaDi;
    private final String mName;
    private final String zzanu;
    private final String zzaDj;
    private final String zzaEA;
    private final List<String> zzaEB;
    final boolean zzaEC;
    private final Map<Integer, String> zzaED;
    private final TimeZone zzaEE;
    private Locale zzaEk;
    private zzo zzaEF;

    PlaceImpl(int versionCode, String id, List<Integer> placeTypes, List<Integer> typesDeprecated, Bundle addressComponents, String name, String address, String phoneNumber, String regularOpenHours, List<String> attributions, LatLng latlng, float levelNumber, LatLngBounds viewport, String timeZoneId, Uri websiteUri, boolean isPermanentlyClosed, float rating, int priceLevel, long timestampSecs, boolean isLoggingEnabled, PlaceLocalization localization) {
        this.mVersionCode = versionCode;
        this.zzwj = id;
        this.zzaDi = Collections.unmodifiableList(placeTypes);
        this.zzaEz = typesDeprecated;
        this.zzaEq = addressComponents != null ? addressComponents : new Bundle();
        this.mName = name;
        this.zzanu = address;
        this.zzaDj = phoneNumber;
        this.zzaEA = regularOpenHours;
        this.zzaEB = attributions != null ? attributions : Collections.emptyList();
        this.zzaDh = latlng;
        this.zzaEs = levelNumber;
        this.zzaEt = viewport;
        this.zzaEu = timeZoneId != null ? timeZoneId : "UTC";
        this.zzaDk = websiteUri;
        this.zzaEv = isPermanentlyClosed;
        this.zzaEw = rating;
        this.zzaEx = priceLevel;
        this.zzaEy = timestampSecs;
        HashMap hashMap = new HashMap();
        this.zzaED = Collections.unmodifiableMap(hashMap);
        this.zzaEE = null;
        this.zzaEk = null;
        this.zzaEC = isLoggingEnabled;
        this.zzaEr = localization;
    }

    @Override
    public String getId() {
        this.zzdA("getId");
        return this.zzwj;
    }

    @Override
    public List<Integer> getPlaceTypes() {
        this.zzdA("getPlaceTypes");
        return this.zzaDi;
    }

    public List<Integer> zzwi() {
        this.zzdA("getTypesDeprecated");
        return this.zzaEz;
    }

    @Override
    public Locale getLocale() {
        this.zzdA("getLocale");
        return this.zzaEk;
    }

    public void setLocale(Locale locale) {
        this.zzaEk = locale;
    }

    @Override
    public String getName() {
        this.zzdA("getName");
        return this.mName;
    }

    @Override
    public String getAddress() {
        this.zzdA("getAddress");
        return this.zzanu;
    }

    @Override
    public LatLng getLatLng() {
        this.zzdA("getLatLng");
        return this.zzaDh;
    }

    public float zzwj() {
        this.zzdA("getLevelNumber");
        return this.zzaEs;
    }

    @Override
    public LatLngBounds getViewport() {
        this.zzdA("getViewport");
        return this.zzaEt;
    }

    @Override
    public Uri getWebsiteUri() {
        this.zzdA("getWebsiteUri");
        return this.zzaDk;
    }

    @Override
    public String getPhoneNumber() {
        this.zzdA("getPhoneNumber");
        return this.zzaDj;
    }

    public String zzwk() {
        this.zzdA("getRegularOpenHours");
        return this.zzaEA;
    }

    public List<String> zzwl() {
        this.zzdA("getAttributions");
        return this.zzaEB;
    }

    public boolean zzwm() {
        this.zzdA("isPermanentlyClosed");
        return this.zzaEv;
    }

    @Override
    public float getRating() {
        this.zzdA("getRating");
        return this.zzaEw;
    }

    @Override
    public int getPriceLevel() {
        this.zzdA("getPriceLevel");
        return this.zzaEx;
    }

    public long zzwn() {
        return this.zzaEy;
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("id", (Object)this.zzwj).zzg("placeTypes", this.zzaDi).zzg("locale", (Object)this.zzaEk).zzg("name", (Object)this.mName).zzg("address", (Object)this.zzanu).zzg("phoneNumber", (Object)this.zzaDj).zzg("latlng", (Object)this.zzaDh).zzg("viewport", (Object)this.zzaEt).zzg("websiteUri", (Object)this.zzaDk).zzg("isPermanentlyClosed", (Object)this.zzaEv).zzg("priceLevel", (Object)this.zzaEx).zzg("timestampSecs", (Object)this.zzaEy).toString();
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzwj, this.zzaEk, this.zzaEy});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlaceImpl)) {
            return false;
        }
        PlaceImpl placeImpl = (PlaceImpl)object;
        return this.zzwj.equals(placeImpl.zzwj) && zzw.equal((Object)this.zzaEk, (Object)placeImpl.zzaEk) && this.zzaEy == placeImpl.zzaEy;
    }

    public Bundle zzwo() {
        return this.zzaEq;
    }

    public String zzwp() {
        return this.zzaEu;
    }

    @Deprecated
    public PlaceLocalization zzwq() {
        this.zzdA("getLocalization");
        return this.zzaEr;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzk.zza(this, parcel, flags);
    }

    public void zza(zzo zzo2) {
        this.zzaEF = zzo2;
    }

    private void zzdA(String string) {
        if (this.zzaEC && this.zzaEF != null) {
            this.zzaEF.zzC(this.zzwj, string);
        }
    }

    public Place zzwr() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public /* synthetic */ Object freeze() {
        return this.zzwr();
    }

    public static class zza {
        private int mVersionCode = 0;
        private String zzwj;
        private Bundle zzaEG;
        private String mName;
        private LatLng zzaDh;
        private float zzaEs;
        private LatLngBounds zzaEt;
        private String zzaEu;
        private Uri zzaDk;
        private boolean zzaEv;
        private float zzaEw;
        private int zzaEx;
        private long zzaEy;
        private List<Integer> zzaEH;
        private String zzanu;
        private String zzaDj;
        private String zzaEA;
        private List<String> zzaEB;
        private boolean zzaEC;

        public zza zzdB(String string) {
            this.zzwj = string;
            return this;
        }

        public zza zzdC(String string) {
            this.mName = string;
            return this;
        }

        public zza zza(LatLng latLng) {
            this.zzaDh = latLng;
            return this;
        }

        public zza zzf(float f) {
            this.zzaEs = f;
            return this;
        }

        public zza zza(LatLngBounds latLngBounds) {
            this.zzaEt = latLngBounds;
            return this;
        }

        public zza zzl(Uri uri) {
            this.zzaDk = uri;
            return this;
        }

        public zza zzah(boolean bl) {
            this.zzaEv = bl;
            return this;
        }

        public zza zzg(float f) {
            this.zzaEw = f;
            return this;
        }

        public zza zzhj(int n) {
            this.zzaEx = n;
            return this;
        }

        public zza zzm(List<Integer> list) {
            this.zzaEH = list;
            return this;
        }

        public zza zzdD(String string) {
            this.zzanu = string;
            return this;
        }

        public zza zzdE(String string) {
            this.zzaDj = string;
            return this;
        }

        public zza zzn(List<String> list) {
            this.zzaEB = list;
            return this;
        }

        public zza zzai(boolean bl) {
            this.zzaEC = bl;
            return this;
        }

        public PlaceImpl zzws() {
            return new PlaceImpl(this.mVersionCode, this.zzwj, this.zzaEH, Collections.emptyList(), this.zzaEG, this.mName, this.zzanu, this.zzaDj, this.zzaEA, this.zzaEB, this.zzaDh, this.zzaEs, this.zzaEt, this.zzaEu, this.zzaDk, this.zzaEv, this.zzaEw, this.zzaEx, this.zzaEy, this.zzaEC, PlaceLocalization.zza(this.mName, this.zzanu, this.zzaDj, this.zzaEA, this.zzaEB));
        }
    }
}

