/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewParent;

class ViewOffsetHelper {
    private final View mView;
    private int mLayoutTop;
    private int mLayoutLeft;
    private int mOffsetTop;
    private int mOffsetLeft;

    public ViewOffsetHelper(View view) {
        this.mView = view;
    }

    public void onViewLayout() {
        this.mLayoutTop = this.mView.getTop();
        this.mLayoutLeft = this.mView.getLeft();
        this.updateOffsets();
    }

    private void updateOffsets() {
        ViewCompat.offsetTopAndBottom((View)this.mView, (int)(this.mOffsetTop - (this.mView.getTop() - this.mLayoutTop)));
        ViewCompat.offsetLeftAndRight((View)this.mView, (int)(this.mOffsetLeft - (this.mView.getLeft() - this.mLayoutLeft)));
        if (Build.VERSION.SDK_INT < 23) {
            ViewOffsetHelper.tickleInvalidationFlag(this.mView);
            ViewParent vp = this.mView.getParent();
            if (vp instanceof View) {
                ViewOffsetHelper.tickleInvalidationFlag((View)vp);
            }
        }
    }

    private static void tickleInvalidationFlag(View view) {
        float x = ViewCompat.getTranslationX((View)view);
        ViewCompat.setTranslationX((View)view, (float)(x + 1.0f));
        ViewCompat.setTranslationX((View)view, (float)x);
    }

    public boolean setTopAndBottomOffset(int offset) {
        if (this.mOffsetTop != offset) {
            this.mOffsetTop = offset;
            this.updateOffsets();
            return true;
        }
        return false;
    }

    public boolean setLeftAndRightOffset(int offset) {
        if (this.mOffsetLeft != offset) {
            this.mOffsetLeft = offset;
            this.updateOffsets();
            return true;
        }
        return false;
    }

    public int getTopAndBottomOffset() {
        return this.mOffsetTop;
    }

    public int getLeftAndRightOffset() {
        return this.mOffsetLeft;
    }
}

