package com.androidbook.salbcr;

import android.content.Intent;
import android.util.Log;

/*
 * Wykorzystuje usug IntentService jako klas bazow
 * w celu umieszczenia poniszych operacji w osobnym wtku.
 */
public class Test30SecBCRService 
extends ALongRunningNonStickyBroadcastService
{
	public static String tag = "Test30SecBCRService";
	
	//Wymagana przez usug IntentService
	public Test30SecBCRService() {
		super("com.ai.android.service.Test30SecBCRService");
	}
	/*
	 * Przeprowadza wewntrz tej metody dugotrwae operacje.
	 * S one przeprowadzane w oddzielnym wtku. 
	 */
	@Override
	protected void handleBroadcastIntent(Intent broadcastIntent) 
	{
		Utils.logThreadSignature(tag);
		Log.d(tag,"Przejscie w stan bezczynnosci na 30 sekund");
		Utils.sleepForInSecs(30);
		String message = 
			broadcastIntent.getStringExtra("message");
		Log.d(tag,"Praca wykonana");
		Log.d(tag,message);
	}
}
