#!/usr/bin/perl

my $maxbitow =  32; # Maksymalna dlugosc wzorca.
my $Sigma   = 256; # Zakladamy, ze tekst jest 8-bitowy.

sub shift_OR_dokladny { # Dokladny algorytm shift-OR
                     # czyli dokladny Baezy-Yatesa-Gonneta.
    use integer;

    my ( $T, $P ) = @_; # Tekst i wzorzec.

    # Sprawdzamy sensownosc danych.

    my ( $n, $m ) = ( length( $T ), length( $P ) );

    die "wzorzec '$P' dluzszy niz $maxbitow\n" if $m > $maxbitow;
    return -1 if $m  > $n;
    return  0 if $m == $n and $P eq $T;
    return  index( $T, $P ) if $m == 1;

    # Wstepne przetwarzanie.

    # Potrzebujemy maski $m bitow 1, czyli $m1b.
    my $m1b = ( 1 << $m ) - 1;
    my ( $i, @tabela, $maska );

    for ( $i = 0; $i < $Sigma; $i++ ) { # Inicjujemy tabele.
        $tabela[ $i ] = $m1b;
    }

    # Dopasowujemy tabele odpowiednio do wzorca.
    for ( $i = 0, $maska = 1 ; $i < $m; $i++, $maska <<= 1 ) {
        $tabela[ ord( substr( $P, $i, 1 ) ) ] &= ~$maska;
    }

    # Dopasowywanie.

    my $ostatnie_i = $m - $m;
    my $stan;
    my $P0     = substr( $P, 0, 1 ); # W celu szybkiego przeskakiwania.
    my $obserwator  = 1 << ( $m - 1 );    # Ten bit wskazuje na dopasowanie.

    for ( $i = 0; $i < $n; $i++ ) {
        # Szybkie przeskakiwanie i szybkie niepowodzenie.
        $i = index( $T, $P0, $i );
        return -1 if $i == -1;

        $stan = $m1b;

        while ( $i < $n ) {
            $stan =              # Zmieniamy stan.
                ( $stan << 1 ) | # Nasze przesuniecie 'Shift' i nasze 'OR'.
                $tabela[ ord( substr( $T, $i, 1 ) ) ];
            # Sprawdzamy, czy mamy dopasowanie.
            return $i - $m + 1 # Jest!
                if ( $stan & $obserwator ) == 0;
            # Rezygnujemy z tej proby dopasowania.
            # (ale jeszcze nie z badania reszty lancucha:
            #  przegralismy bitwe, ale jeszcze nie przegralismy wojny)
            last if $stan == $m1b;
            $i++;
        }
    }

    return -1; # Brak dopasowania.
}
