#!/usr/bin/perl

my $Sigma = 256; # Rozmiar alfabetu.

sub boyer_moore_zly_znak {
    my ( $P ) = @_; # Wzorzec.
    use integer;
    my ( $m, $i, $j ) = ( length( $P ) );
    my @zz = ( $m ) x $Sigma;
    for ( $i = 0, $j = $m - 1; $i < $m; $i++ ) {
        $zz[ ord( substr( $P, $i, 1 ) ) ] = $j--;
    }

    return ( $m, @zz ); # Dlugosc wzorca i zasada zlego znaku.
}

sub boyer_moore_dobry_przyrostek {
    my ( $P, $m ) = @_; # Wzorzec i jego dlugosc.
    use integer;
    my ($i, $j, $k, @k);
    my ( @dp ) = ( 0 ) x ( $m + 1 );
    $k[ $m ] = $j = $m + 1;

    for ( $i = $m; $i > 0; $i-- ) {
        while ( $j <= $m &&
                substr( $P, $i - 1, 1 ) ne substr($P, $j - 1, 1)) {
            $dp[ $j ] = $j - $i if $dp[ $j ] == 0;
            $j = $k[ $j ];
        }
        $k[ $i - 1 ] = --$j;
    }

    $k = $k[ 0 ];

    for ($j = 0; $j <= $m; $j++ ) {
        $dp[ $j ] = $k       if $dp[ $j ] == 0;
        $k        = $k[ $k ] if      $j   == $k;
    }

    shift @dp;
    return @dp; # Zasada dobrego przyrostka.
}

sub boyer_moore {
    my ( $T, $P ) = @_; # Tekst i wzorzec.
    use integer;
    my ( $m, @zz ) = boyer_moore_zly_znak( $P );
    my ( @dp )     = boyer_moore_dobry_przyrostek( $P, $m );
    my ( $i, $ostatni_i, $pierwszy_j, $j ) = ( 0, length( $T ) - $m, $m - 1 );

    while ( $i <= $ostatni_i ) {
        for ( $j = $pierwszy_j;
              $j >= 0 &&
              substr( $T, $i + $j, 1) eq substr( $P, $j, 1 );
              --$j )
          {
              # Zmniejszamy $j dopoki nie znajdziemy niedopasowania.
          }
        if ( $j < 0 ) {
            return $i; # Dopasowanie.
            # Jesli chcemy zwracac wszystkie dopasowania zamiast
            # tylko pierwszego, powinnismy uzyc takiego kodu:
            # push @i, $i;
            # $i + $dp[ $j + 1 ];
            # i na koncu funkcji dodac:
            # return @i;
        } else {
            my $zz = $zz[ ord( substr($T, $i + $j, 1) ) ] - $m + $j + 1;
            my $dp = $dp[ $j ];
            $i += $zz > $dp ? $zz : $dp; # Wybieramy najwiekszy przeskok.
        }
    }

    return -1; # Brak dopasowania.
}
