#!/usr/bin/perl

# edge_classify
#
#       @C = $G->edge_classify()
#
#       Zwraca klasyfikacje w postaci listy, w ktorej kazdy element podaje
#       trzy charakterystyki [$u, $v, $class], $u, $v to wierzcholki
#       krawedzi, a $class to jej klasa.
#
sub edge_classify {
    my $G = shift;

    my $unseen_successor =
        sub {
            my ($u, $v, $T) = @_;

            # Ostatnio odwiedzani sukcesorzy dla potrzeb krawedzi drzewa.
            push @{ $T->{ edge_class_list } },
                 [ $u, $v, 'tree' ];
        };
    my $seen_successor =
        sub {
            my ($u, $v, $T) = @_;

            my $class;

            if ( $T->{ G }->directed ) {
                $class = 'cross'; # Domyslne dla skierowanych krawedzi nie nalezacych do drzewa.

                unless ( exists $T->{ vertex_finished }->{ $v } ) {
                    $class = 'back';

                } elsif ( $T->{ vertex_found }->{ $u } <
                          $T->{ vertex_found }->{ $v }) {
                    $class = 'forward';
                }
            } else {
                # W nieskierowanym grafie z definicji sa tylko 
                # krawedzie wskazujace wstecz.
                $class = 'back';
            }

            push @{ $T->{ edge_class_list } }, [ $u, $v, $class ];
        };
    use Graph::DFS;
    my $d =
        Graph::DFS->
            new( $G,
                 unseen_successor => $unseen_successor,
                 seen_successor   => $seen_successor,
                 @_);

    $d->preorder; # Trawersowanie.

    return @{ $d->{ edge_class_list } };
}
