#!/usr/bin/perl

# punkty artykulacji
#
#       @A = $G->articulation_points()
#
#      Zwraca w @A zestaw punktow artykulacji (wierzcholkow) grafu $G.
#
sub articulation_points {
    my $G = shift;
    my $articulate =

        sub {
              my ( $u, $T ) = @_;

              my $ap = $T->{ vertex_found }->{ $u };

              my @S = @{ $T->{ active_list } }; # Biezacy stos.

              $T->{ articulation_point }->{ $u } = $ap
                  unless exists $T->{ articulation_point }->{ $u };

              # Cofamy sie w stosie oznaczajac aktywna galaz drzewa szukania 
              # w glab(pod $u) jako nalezaca do punktu artykulacji $ap.
              for ( my $i = 1; $i < @S; $i++ ) {
                  my $v = $S[ -$i ];

                  last if $v eq $u;

                  $T->{ articulation_point }->{ $v } = $ap
                      if not exists $T->{ articulation_point }->{ $v } or
                         $ap < $T->{ articulation_point }->{ $v };
            }
        };

    my $unseen_successor =
        sub {
              my ($u, $v, $T) = @_;

              # Potrzebna nam liczba potomkow wierzcholka bazowego.
              $T->{ articulation_children }->{ $u }++;
        };
    my $seen_successor =
        sub {
              my ($u, $v, $T) = @_;

              # Jesli $v jest nadal aktywny, dokonujemy jego artykulacji.
              $articulate->( $v, $T )
                  if exists $T->{ active_pool }->{ $v };
        };
    my $d =
        Graph::DFS->new($G,
                        articulate       => $articulate,
                        unseen_successor => $unseen_successor,
                        seen_successor   => $seen_successor,
                        );

    $d->preorder; # Trawersujemy.

    # Teraz musimy odnalezc punkty artykulacji (ich indeksy)  
    # i mapowac je z powrortem na wierzcholki.

    my (%ap, @vf);

    foreach my $v ( $G->vertices ) {
        $ap{ $d->{ articulation_point }->{ $v } } = $v;
        $vf[ $d->{ vertex_found       }->{ $v } ] = $v;
    }

    %ap = map { ( $vf[ $_ ], $_ ) } keys %ap;

    # wierzcholki bazowe drzewa przeszukiwania w glab sa punktami
    # artykulacji tylko jesli maja wiecej niz jednego potomka.
    foreach my $r ( $d->roots ) {
        delete $ap{ $r } if $d->{ articulation_children }->{ $r } < 2;
    }

    keys %ap;
}

use Graph::Undirected;

my $Alphaville = Graph::Undirected->new;

$Alphaville->add_path( qw( Uniwersytet Cmentarz DworzecAutobusowy
                           StaryPort Uniwersytet ) );
$Alphaville->add_path( qw( StaryPort PoludniowyPort Przystan
                           KlubZeglarski PoludniowyPort ) );
$Alphaville->add_path( qw( DworzecAutobusowy Ratusz CentrumHandlowe DworzecAutobusowy ) );
$Alphaville->add_path( qw( CentrumHandlowe Lotnisko ) );

my @ap  = $Alphaville->articulation_points;

print "punkty artykulacji w Alphaville = @ap\n";
