#!/usr/bin/perl

use kolko_i_krzyzyk;

# Stosowanie:
#    Aby wybrac nastepny ruch:
#        ($ruchy,$wynik) = minimaks($pozycja,$glebokosc)
#    Dostarcz obiekt pozycji i maksymalna glebokosc 
#    (liczbe ruchow), ktore beda sprawdzane, zanim przerwiemy
#    generowanie ruchu i ocenimy otrzymana pozycje.
#    Zwraca dwie wartosci:
#     1: odwolanie do listy ruchow (ostatni element listy jest
#        pozycja na koniec ciagu ruchow - niezaleznie czy dlatego, ze
#        tak wynika z parametru $glebokosc, ktory nie pozwala zbadac
#        wiecej ruchow, czy tez dlatego, ze jest to koncowa pozycja.
#     2: ostateczny wynik

sub minimaks {
    my ( $pozycja, $glebokosc ) = @_;

    # Czy dotarlismy tak gleboko jak to mozliwe?
    if ( $glebokosc-- and defined($pozycja->przygotuj_ruchy) ) {
        # Nie - probujemy innych ruchow z tej $pozycja.
        my $ruch;
        my $najlepsza_ocena = -$pozycja->najlepszy_wynik;
        my $najlepsza_kol_ruchow;

        while ( defined( $ruch = $pozycja->nastepny_ruch ) ) {
            # Oceniamy nastepny ruch.
            my ( $ta_kolejnosc_rochow, $ten_wynik ) =
                minimaks(
                    $pozycja->wykonaj_ruch($ruch),
                    $glebokosc );
            # Wynik przeciwnika jest odwrotny do naszego.
            $ten_wynik = -$ten_wynik;
            if ( $ten_wynik > $najlepsza_ocena ) {
                $najlepsza_ocena = $ten_wynik;
                $najlepsza_kol_ruchow = $ta_kolejnosc_rochow;
                unshift ( @$najlepsza_kol_ruchow, $ruch );
            }
        }

        # Zwracamy, najlepszy wariant, ktory znalezlismy.
        return ( $najlepsza_kol_ruchow, $najlepsza_ocena );

    } else {
        # Tak - oceniamy biezaca pozycje, nie wykonujemy ruchu.
        return ( [ $pozycja ], -$pozycja->oceniaj );
    }
}

my $gra = kolko_i_krzyzyk->new( );

my ( $ruchy, $wynik ) = minimaks( $gra, 2 );
my $moj_ruch = $ruchy->[0];
print "Moj ruch: $moj_ruch\n";
