#!/usr/bin/perl

sub qbsort {
    qbsort_quick( $_[0], 0, $#{ $_[0] }, defined $_[1] ? $_[1] : 10 );
    bubblelepsze( $_[0] ); # Uzywamy wariantu szybkiego dla prawie posortowanych danych.
}

# Pierwsza czesc sortowania quickbubblesort: quicksort.
# Zwyczajny algorytm quicksort (wybierajacy os z trzech elementow)
# poza tym, ze sortowane sa tylko czesci wieksze niz $szerokosc.

sub qbsort_quick {
    my ( $tablica, $pierwszy, $ostatni, $szerokosc ) = @_;
    my @stos = ( $pierwszy, $ostatni );

    do {
        if ( $ostatni - $pierwszy > $szerokosc ) {
            my ( $ostatni_z_pierwszych, $pierwszy_z_ostatnich ) =
                dzielenieWz3( $tablica, $pierwszy, $ostatni );

            if ( $pierwszy_z_ostatnich - $pierwszy > $ostatni - $ostatni_z_pierwszych ) {
                push @stos, $pierwszy, $pierwszy_z_ostatnich;
                $pierwszy = $ostatni_z_pierwszych;
            } else {
                push @stos, $ostatni_z_pierwszych, $ostatni;
                $ostatni = $pierwszy_z_ostatnich;
            }
        } else { # Pop.
            ( $pierwszy, $ostatni ) = splice @stos, -2, 2;
        }
    } while @stos;
}

sub dzielenieWz3 {
    my ( $tablica, $pierwszy, $ostatni ) = @_;

    use integer;

    my $srodkowy = int(( $pierwszy + $ostatni ) / 2);

    # Zamieniamy miejscami pierwszy, ostatni i srodkowy, aby 
    # sredni z nich znalazl sie w srodku.

    @$tablica[ $pierwszy, $srodkowy ] = @$tablica[ $srodkowy, $pierwszy ]
        if ( $$tablica[ $pierwszy ] gt $$tablica[ $srodkowy ] );

    @$tablica[ $pierwszy, $ostatni ] = @$tablica[ $ostatni, $pierwszy ]
        if ( $$tablica[ $pierwszy ] gt $$tablica[ $ostatni ] );

    @$tablica[ $srodkowy, $ostatni ] = @$tablica[ $ostatni, $srodkowy ]
        if ( $$tablica[ $srodkowy ] lt $$tablica[ $ostatni ] );

    my $i = $pierwszy;
    my $j = $ostatni - 1;
    my $nasza_os = $$tablica[ $ostatni ];

    # Teraz dzielimy korzystajac z wybranej sredniej.

 SKAN: {
        do {
            # $pierwszy <= $i <= $j <= $ostatni - 1
            # Punkt 1.

            # Przenosimy $i tak daleko, jak sie da.
            while ( $$tablica[ $i ] le $nasza_os ) {
                $i++;
                last SKAN if $j < $i;
            }

            # Przenosimy $j tak daleko, jak sie da.
            while ( $$tablica[ $j ] ge $nasza_os ) {
                $j--;
                last SKAN if $j < $i;
            }

            # $i i $j nie trafiaja na siebie,
            # zamieniamy miejscami wieksza i mniejsza wartosc.
            @$tablica[ $j, $i ] = @$tablica[ $i, $j ];
        } while ( --$j >= ++$i );
    }
    # $pierwszy - 1 <= $j <= $i <= $ostatni
    # Punkt 2.

    # Zamieniamy nasza_os z pierwszym wiekszym elementem
    # (jesli taki jest).
    if( $i < $ostatni ) {
        @$tablica[ $ostatni, $i ] = @$tablica[ $i, $ostatni ];
        ++$i;
    }

    # Punkt 3.

    return ( $i, $j );   # Nowe granice wykluczaja srodek.
}

sub bubblelepsze {
    my $tablica = shift;
    my $start = 0;        # Poczatkowy indeks skanowania.
    my $lporown = 0;        # Liczba porownan.
    my $lzamian = 0;        # Liczba zamian.

    my $i = $#$tablica;

    while ( 1 ) {
        my $nowy_start;    # Nowy startowy indeks skanowania.
        my $nowy_koniec = 0;  # Nowy koncowy indeks skanowania.

        for ( my $j = $start || 1; $j <= $i; $j++ ) {
            $lporown++;
            if ( $tablica->[ $j - 1 ] gt $tablica->[ $j ] ) {
                @$tablica[ $j, $j - 1 ] = @$tablica[ $j - 1, $j ];
                $lzamian++;
                $nowy_koniec   = $j - 1;
                $nowy_start = $j - 1 unless defined $nowy_start;
            }
        }
        last unless defined $nowy_start; # Zadnych nowych zamian: koniec.
        ;
        $start = $nowy_start;
    }
}

@tablica = qw(Dalczego nigdzie nie ma B baterii?  Zaraz, zaraz. Baterii A tez chyba nie ma?);

qbsort( \@tablica );

print "@tablica\n";
