#!/usr/bin/perl

# zoz_jako_lancuch($zbior) zwraza ulancuchowiona reprezentacje
# zbioru zbiorow. $lancuch jest poczotkowo niezdefiniowane, i jest
# zapelniane tylko gdy zoz_jako_lancuch() przyzwie siebie sama pozniej.
#
sub zoz_jako_lancuch ($;$) {
    my ( $zbior, $lancuch ) = @_;

    $$lancuch .= '{';                             # Poczatkowy nawias

    my $i;                                       # Liczba elementow

    foreach my $klucz ( keys %{ $zbior } ) {
        # Dodajemy spacje miedzy elementami.
        $$lancuch .= ' ' if $i++;
        if ( ref $zbior->{ $klucz } ) {
            zoz_jako_lancuch( $zbior->{ $klucz }, $lancuch );  # Rekurencja
        } else {
            $$lancuch .= $klucz;                          # Dodajemy element
        }
    }

    return $$lancuch .= '}';                      # Koncowy nawias
}

my $a  = { ab => 12, cd => 34, ef => 56 };
# Trzeba pamietac, ze zbiory zbiorow sa reprezentowane za pomoca rownych
# sobie kluczy i wartosci: dotyczy to $a, $a a takze $b, $b oraz $n1, $n1.
my $b  = { pq => 23, rs => 45, tu => 67, $a, $a };
my $c  = { xy => 78, $b, $b, zx => 89 };

my $n1 = { };
my $n2 = { $n1, $n1 };

print "a  = ", zoz_jako_lancuch( $a  ), "\n";
print "b  = ", zoz_jako_lancuch( $b  ), "\n";
print "c  = ", zoz_jako_lancuch( $c  ), "\n";
print "n1 = ", zoz_jako_lancuch( $n1 ), "\n";
print "n2 = ", zoz_jako_lancuch( $n2 ), "\n";
