#!/usr/bin/perl

# Zapamietywanie maski dla zbior_potegowy_iter().
my @_zbior_potegowy_iter_mask = ( );

sub zbior_potegowy_iter {
    my $zbior = shift;

    my @klucze     = keys   %{ $zbior };
    my @wartosci   = values %{ $zbior };
    # Liczba elementow w oryginalnym zbiorze.
    my $nelementow = @klucze;
    # Liczba podzbiorow w zbiorze potegowym.
    my $npodzbiorow = 1 << $nelementow;
    my ( $i, $j, $zbior_potegowy, $podzbior );

    # Wyliczamy i zachowujemy potrzebna maske.
    if ( $nelementow > @_zbior_potegowy_iter_mask ) {
        for ( $j = @_zbior_potegowy_iter_mask; $j < $nelementow; $j++ ) {
            # Operacja 1 << $j dziala dobrze tylko do $nelementow == 31.
            push( @_zbior_potegowy_iter_mask, 1 << $j );
        }
    }

    for ( $i = 0; $i < $npodzbiorow; $i++ ) {
        $podzbior = { };
        for ( $j = 0; $j < $nelementow; $j++ ) {
            # Dodajemy i-ty element, jesli jest w j-ej masce.
            $podzbior->{ $klucze[ $j ] } = $wartosci[ $j ]
                if $i & $_zbior_potegowy_iter_mask[ $j ];
        }
        $zbior_potegowy->{ $podzbior } = $podzbior;
    }

    return $zbior_potegowy;
}

my $a  = { a => 12, b => 34, c => 56 };

my $pi = zbior_potegowy_iter( $a );

print "pi = ", zoz_jako_lancuch( $pi ), "\n";

# zoz_jako_lancuch($zbior) zwraza ulancuchowiona reprezentacje
# zbioru zbiorow. $lancuch jest poczotkowo niezdefiniowane, i jest
# zapelniane tylko gdy zoz_jako_lancuch() przyzwie siebie sama pozniej.
#
sub zoz_jako_lancuch ($;$) {
    my ( $zbior, $lancuch ) = @_;

    $$lancuch .= '{';                             # Poczatkowy nawias

    my $i;                                       # Liczba elementow

    foreach my $klucz ( keys %{ $zbior } ) {
        # Dodajemy spacje miedzy elementami.
        $$lancuch .= ' ' if $i++;
        if ( ref $zbior->{ $klucz } ) {
            zoz_jako_lancuch( $zbior->{ $klucz }, $lancuch );  # Rekurencja
        } else {
            $$lancuch .= $klucz;                          # Dodajemy element
        }
    }

    return $$lancuch .= '}';                      # Koncowy nawias
}
