sub porownaj_wektory_bitow {
    my ( $wektor1, $wektor2, $nbitow ) = @_;

    # Rozszerzanie bitow.
    my $gornybit = $nbitow - 1;
    vec( $wektor1, $gornybit, 1 ) = vec( $wektor1, $gornybit, 1 );
    vec( $wektor2, $gornybit, 1 ) = vec( $wektor2, $gornybit, 1 );

    return 'rowne'              if $wektor1 eq $wektor2;
    # =~ /^\0*$/ sprawdza, czy wektor bitow nie zawiera samych zer
    # (lub czy nie jest pusty, co oznacza tyle samo).
    return 'podzbior wlasciwy'      if ($wektor1 & ~$wektor2) =~ /^\0*$/;
    return 'nadzbior wlasciwy'    if ($wektor2 & ~$wektor1) =~ /^\0*$/;
    return 'rozloacznosc'           if ($wektor1 &  $wektor2) =~ /^\0*$/;
    # Nigdy nie zwraca informacji o zwyklym podzbiorze czy nadzbiorze.
    return 'przekroj wlasciwy';
}

%Psowate = %Canidae = %Kotowate = %WielkieKoty = %Miesozercy = ();

@Psowate{ qw(lis wilk) }                       = ( );
@Canidae{ qw(lis wilk) }                       = ( );
@Kotowate{ qw(cat tygrys lew) }                 = ( );
@WielkieKoty{ qw(tygrys lew) }                     = ( );
@Miesozercy{ qw(wilk tygrys lew borsuk foka) } = ( );

( $rozmiar, $liczby ) =
        elementy_na_liczby( \%Psowate, \%Canidae,
                            \%Kotowate, \%WielkieKoty,
                            \%Miesozercy );

$Psowate    = tablica_asoc_na_wektor_bitow( \%Psowate,    $liczby );

$Canidae    = tablica_asoc_na_wektor_bitow( \%Canidae,    $liczby );

$Kotowate    = tablica_asoc_na_wektor_bitow( \%Kotowate,    $liczby );

$WielkieKoty    = tablica_asoc_na_wektor_bitow( \%WielkieKoty,    $liczby );

$Miesozercy = tablica_asoc_na_wektor_bitow( \%Miesozercy, $liczby );

printf "Psowate cmp Canidae    = %s\n",
        porownaj_wektory_bitow( $Psowate,    $Canidae,    $rozmiar );

printf "Psowate cmp Kotowate    = %s\n",
        porownaj_wektory_bitow( $Psowate,    $Kotowate,    $rozmiar );

printf "Psowate cmp Miesozercy = %s\n",
        porownaj_wektory_bitow( $Psowate,    $Miesozercy, $rozmiar );

printf "Miesozercy cmp Psowate = %s\n",
        porownaj_wektory_bitow( $Miesozercy, $Psowate,    $rozmiar );

printf "Kotowate cmp WielkieKoty = %s\n",
        porownaj_wektory_bitow( $Kotowate,    $WielkieKoty,    $rozmiar );

printf "WielkieKoty cmp Kotowate = %s\n",
        porownaj_wektory_bitow( $WielkieKoty,    $Kotowate,    $rozmiar );


sub elementy_na_liczby {
    my ( @nazwy,   $nazwa );
    my ( %liczby, $liczba );

    $liczba = 0;
    while ( my $zbior = shift @_ ) {
        while ( defined ( $nazwa = each %$zbior ) ) {
            unless ( exists $liczby{ $nazwa } ) {
        $liczby{ $nazwa   } = $liczba;
        $nazwy  [ $liczba ] = $nazwa;
        $liczba++;
            }
        }
    }

    return ( $liczba, \%liczby, \@nazwy );
}

sub tablica_asoc_na_wektor_bitow {
    my ( $hash, $liczby ) = @_;
    my ( $nazwa, $wektor );

    # Inicjujemy $wektor bitami zerowymi.
    #
    $wektor = '';

    while ( defined ($nazwa = each %{ $hash })) {
        vec( $wektor, $liczby->{ $nazwa }, 1 ) = 1;
    }

    return $wektor;
}

sub wektor_bitow_na_tablice_asoc {
    my ( $wektor, $nazwy ) = @_;
    my ( $liczba, %zbior_tablica_asoc );

    foreach $liczba ( 0..$#{ $nazwy }) {
        $zbior_tablica_asoc{ $nazwy->[ $liczba ] } = undef
            if vec( $wektor, $liczba, 1 );
    }

    return \%zbior_tablica_asoc;
}

