#!/usr/bin/perl

sub shift_ADD ($$;$) { # algorytm shift-add czyli.
                       # algorytm Baezy-Yatesa k-niedopasowan.

    my $maxbitow =  32; # Maksymalna dlugosc wzorca.
    my $Sigma   = 256; # Zakladamy tekst 8-bitowy.

    my ( $T, $P, $k ) = @_; # Tekst, wzorzec oraz maksymalna
                            # liczba niedopasowan.

    # Badamy sensownosc danych.

    my $n = length( $T );

    $k = int( log( $n ) + 1 ) unless defined $k; # O(n lg n)
    return index( $T, $P ) if $k == 0; # Sposob na przyspieszenie.

    my $m = length( $P );

    return index( $T, $P ) if $m == 1; # I kolejny.

    die "wzorzec '$P' dluzszy niz $maxbitow\n" if $m > $maxbitow;
    return -1 if $m > $n;
    return  0 if $m == $n and $P eq $T;

    # Wstepne przetwarzanie.

    # Potrzebujemy licznikow szerokich na przynajmniej ( log ( k+1 ) ) + 1.
    #                                                       2
    # 1.4427 to w przyblizeniu 1 / log(2).
    my $bity = int ( 1.4427 * log( $k + 1 ) + 0.5) + 1;
    if ( $m * $bity > $maxbitow ) {
        warn "zbyt wiele niedopasowan $k dla wzorca '$P'\n";
        die "maksimum ", $maxbitow / $m / $bity, "\n";
    }

    use integer;

    my ( $maska, $maska_przepelnienia ) = ( 1 << ( $bity - 1 ), 0 );
    my ( $i, @tabela );

    # Initialize the $maska_przepelnienia for masking out the counter overflows.
    # Also the $maska gets shifted to its rightful place.
    for ( $i = 0; $i < $m; $i++ ) {
        $maska_przepelnienia |= $maska;
        $maska <<= $bity; # The $m * $bity lowest bits will end up 0.
    }
    # Now every ${bits}th bit of $maska_przepelnienia is 1.
    # For example if $bity == 3, $maska_przepelnienia is ...100100100.

    $tabela[ 0 ] = $maska_przepelnienia >> ( $bity - 1 ); # Inicjujemy tabela[0].
    # Kopiujemy poczatkowe bity tabela[1..].
    for ( $i = 1; $i < $Sigma; $i++ ) {
        $tabela[ $i ] = $tabela[ 0 ];
    }
    # Teraz wszystkie liczniki dla wszystkich pozycji w @tabela sa inicjowane jako 1.
    # Na przyklad $bity == 3, to pozycje w @tabela beda takie ..001001001.

    # Liczniki odpowiadajace znakom $P sa zerowane.
    # (Zauwazcie, ze $maska zaczyna teraz nowe zycie.)
    for ( $i = 0, $maska = 1 ; $i < $m; $i++, $maska <<= $bity ) {
        $tabela[ ord( substr( $P, $i, 1 ) ) ] &= ~$maska;
    }

    # Szukamy.

    $maska     = ( 1 << ( $m * $bity) ) - 1;
    my $stan = $maska & ~$maska_przepelnienia;
    my $przepel    = $maska_przepelnienia; # $przepel bedzie rejestrowac przepelnienia licznika.
    # Dopasowanie jest mozliwe tylko jesli $stan nie zawiera tych bitow.
    my $watch = ( $k + 1 ) << ( $bity * ( $m - 1 ) );

    for ( $i = 0; $i < $n; $i++ ) {
        $stan =                           # Przechodzimy do kolejnego stanu.
            ( ( $stan << $bity ) +        # Nasze przesuniecie 'Shift' i nasze 'ADD'.
            $tabela[ ord( substr( $T, $i, 1 ) ) ] ) & $maska;
        $przepel =                              # Rejestrujemy przepelnienia.
            ( ( $przepel << $bity ) |
              ( $stan & $maska_przepelnienia) )                & $maska;
        $stan &= ~$maska_przepelnienia;                # Czyscimy przepelnienia.
        if ( ( $stan | $przepel ) < $watch ) { # Szukamy dopasowania.
            # Mamy dopasowanie z tyloma
            # $stan >> ( $bity * ( $m - 1 ) ) ) niedopasowaniami.
            return $i - $m + 1; # Znalezlismy dopasowanie.
        }
    }

    return -1; # Brak dopasowania.
}
