#!/usr/bin/perl

use constant ROZMIAR_CZESCI => 5;

# UWAGA 1: $indeks w procedurze wybieranie() zaczyna sie od 1 nie od 0.
# UWAGA 2: gdy $N beda rowne, wybieranie() zwraca wieksza z
#         "dwoch median", a nie srednia z nich, jak jest w zwyczaju--
#         jesli to wam przeszkadza, napiszcie wlasny wariant.

sub wybieranie {
    # $tablica:   odwolanie do tablicy, z ktorej wybieramy.
    # $porownanie: odwolanie do kodu porownujacego dwa elementy,
    #           musi zwracac -1, 0, 1.
    # $indeks:   poszukiwany indeks w tablicy.
    my ($tablica, $porownanie, $indeks) = @_;

    my $N = @$tablica;

    # Szybki przeglad czesci.
    return (sort { $porownanie->($a, $b) } @$tablica)[ $indeks-1 ]
         if $N <= ROZMIAR_CZESCI;

    my $mediany;

    # Znajdowanie median dla czesci $N/5.
    for ( my $i = 0; $i < $N; $i += ROZMIAR_CZESCI ) {
        my $s =                 # Rozmiar tej czesci.
            $i + ROZMIAR_CZESCI < $N ?
                ROZMIAR_CZESCI : $N - $i;

        my @s =                 # Ta czesc zostala posortowana.
            sort { $tablica->[ $i + $a ] cmp $tablica->[ $i + $b ] }
                 0 .. $s-1;
        push @{ $mediany },     # Zbieramy mediany.
             $tablica->[ $i + $s[ int( $s / 2 ) ] ];
    }

    # Wracamy, aby znalezc mediane z median.
    my $median = wybieranie( $mediany, $porownanie, int( @$mediany / 2 ) );
    my @kind;

    use constant MNIEJSZY    => 0;
    use constant ROWNY   => 1;
    use constant WIEKSZY => 2;

    # Elementy MNIEJSZE-niz trafiaja do @{$kind[MNIEJSZY]},
    # Elementy ROWNE trafiaja do @{$kind[ROWNY]},
    # Elementy WIEKSZE-niz trafiaja do @{$kind[WIEKSZY]}.
    foreach my $elem (@$tablica) {
        push @{ $kind[$porownanie->($elem, $median) + 1] }, $elem;
    }

    return wybieranie( $kind[MNIEJSZY], $porownanie, $indeks )
        if $indeks <= @{ $kind[MNIEJSZY]  };

    $indeks -= @{ $kind[MNIEJSZY] };

    return $median
        if $indeks <= @{ $kind[ROWNY] };
 
    $indeks -= @{ $kind[ROWNY] };

    return wybieranie( $kind[WIEKSZY], $porownanie, $indeks );
}

sub median {
    my $tablica = shift;
    return wybieranie( $tablica,
                      sub { $_[0] <=> $_[1] },
                      @$tablica / 2 + 1 );
}

sub percentyl {
    my ($tablica, $percentyl) = @_;
    return wybieranie( $tablica,
                      sub { $_[0] <=> $_[1] },
                      (@$tablica * $percentyl) / 100 );
}

@wyniki = qw(40 53 77 49 78 20 89 35 68 55 52 71);

print percentyl(\@wyniki, 90), "\n";
