#!/usr/bin/perl

sub zbior_potegowy_rekurenc ($;@) {
    my ( $zbior, $zbior_potegowy, $klucze, $wartosci, $n, $i ) = @_;

    if ( @_ == 1 ) { # Inicjujemy.
        my $null   = { };
        $zbior_potegowy  = { $null, $null };
        $klucze      = [ keys   %{ $zbior } ];
        $wartosci    = [ values %{ $zbior } ];
        $nwartosci  = keys %{ $zbior };    # Tyle razy.
        $i         = 0;                 # Numer biezacego razu.
    }

    # Gotowy?
    return $zbior_potegowy if $i == $nwartosci;

    # Remap.

    my @klucze_potegowego   = keys   %{ $zbior_potegowy };
    my @wartosci_potegowego = values %{ $zbior_potegowy };
    my $potegowyn      = @klucze_potegowego;
    my $j;

    for ( $j = 0; $j < $potegowyn; $j++ ) {
        my %podzbior = ( );

        # Kopiujemy stary zbior do podzbioru.
        @podzbior{keys   %{ $zbior_potegowy->{ $klucze_potegowego  [ $j ] } }} =
                values %{ $zbior_potegowy->{ $wartosci_potegowego[ $j ] } };

        # Dodajemy nowy elemnt do podzbioru.
        $podzbior{$klucze->[ $i ]} = $wartosci->[ $i ];

        # Dodajemy nowy podzbior do zbioru potegowego.
        $zbior_potegowy->{ \%podzbior } = \%podzbior;
    }

    # Rekurencja.
    zbior_potegowy_rekurenc( $zbior, $zbior_potegowy, $klucze, $wartosci, $nwartosci, $i+1 );
}

my $a  = { a => 12, b => 34, c => 56 };
my $pr = zbior_potegowy_rekurenc( $a );

print "pr = ", zoz_jako_lancuch( $pr ), "\n";

# zoz_jako_lancuch($zbior) zwraza ulancuchowiona reprezentacje
# zbioru zbiorow. $lancuch jest poczotkowo niezdefiniowane, i jest
# zapelniane tylko gdy zoz_jako_lancuch() przyzwie siebie sama pozniej.
#
sub zoz_jako_lancuch ($;$) {
    my ( $zbior, $lancuch ) = @_;

    $$lancuch .= '{';                             # Poczatkowy nawias

    my $i;                                       # Liczba elementow

    foreach my $klucz ( keys %{ $zbior } ) {
        # Dodajemy spacje miedzy elementami.
        $$lancuch .= ' ' if $i++;
        if ( ref $zbior->{ $klucz } ) {
            zoz_jako_lancuch( $zbior->{ $klucz }, $lancuch );  # Rekurencja
        } else {
            $$lancuch .= $klucz;                          # Dodajemy element
        }
    }

    return $$lancuch .= '}';                      # Koncowy nawias
}
