#!/usr/bin/perl -w

@Psowate{ qw(pies wilk) } = ( );
@Udomowione{ qw(kot pies kon) } = ( );

( undef, $liczby, $nazwy ) = elementy_na_liczby( \%Udomowione, \%Psowate );

$Udomowione = tablica_asoc_na_wektor_bitow( \%Udomowione, $liczby );
$Psowate = tablica_asoc_na_wektor_bitow( \%Psowate, $liczby );

# Maska binarna to AND i NOT.
$roznica           = $Psowate & ~$Udomowione;

# Binarne XOR.
$symetryczna_roznica = $Psowate ^  $Udomowione;

print "roznica = ",
      "@{[keys %{wektor_bitow_na_tablice_asoc( $roznica, $nazwy )}]}\n";
print "symetryczna_roznica = ",
      "@{[keys %{wektor_bitow_na_tablice_asoc( $symetryczna_roznica,
                                       $nazwy )}]}\n";

sub wektor_bitow_na_tablice_asoc {
    my ( $wektor, $nazwy ) = @_;
    my ( $liczba, %zbior_tablica_asoc );

    foreach $liczba ( 0..$#{ $nazwy }) {
        $zbior_tablica_asoc{ $nazwy->[ $liczba ] } = undef
            if vec( $wektor, $liczba, 1 );
    }

    return \%zbior_tablica_asoc;
}

sub tablica_asoc_na_wektor_bitow {
    my ( $hash, $liczby ) = @_;
    my ( $nazwa, $wektor );

    # Inicjujemy $wektor bitami zerowymi.
    #
    $wektor = '';

    while ( defined ($nazwa = each %{ $hash })) {
        vec( $wektor, $liczby->{ $nazwa }, 1 ) = 1;
    }

    return $wektor;
}

sub elementy_na_liczby {
    my ( @nazwy,   $nazwa );
    my ( %liczby, $liczba );

    $liczba = 0;
    while ( my $zbior = shift @_ ) {
        while ( defined ( $nazwa = each %$zbior ) ) {
            unless ( exists $liczby{ $nazwa } ) {
        $liczby{ $nazwa   } = $liczba;
        $nazwy  [ $liczba ] = $nazwa;
        $liczba++;
            }
        }
    }

    return ( $liczba, \%liczby, \@nazwy );
}
