#!/usr/bin/perl

sub rabin_karp_suma_z_bigint {
    my ( $S ) = @_; # Lancuch.

    use Math::BigInt;

    my $n = 1;
    my $KRsuma = Math::BigInt->new(   "0" );
    my $Sigma = Math::BigInt->new( "256" );
    my $cyfra;
    my $c;

    foreach $c ( unpack("C*", $S ) ) {
        $KRsuma = $KRsuma * $Sigma + $c;  # Zasada Hornera.
    }

    return $KRsuma; # Suma.
}

print rabin_karp_suma_z_bigint( "ABCDE" ), "\n";
