#!/usr/bin/perl

# _strongly_connected
#
#       $s = $G->_strongly_connected
#
#       (TYLKO DO UZYTKU WEWNETRZNEGO)
#       Zwraca obiekt trawer trawersowania grafu, ktory mozna 
#       wykorzystac do sprawdzania spojnosci.
#
#
sub _strongly_connected {
    my $G = shift;
    my $T = $G->transpose;

    Graph::DFS->
        new($T,
            # Wybieramy potencjalne wierzcholki bazowe (w porzadku odwroconym).
            strong_root_order => [ Graph::DFS->new($T)->postorder ],
            get_next_root     =>
                sub {
                      my ($T, %param) = @_;

                      while (my $root =
                             shift @{ $param{ strong_root_order } }) {
                          return $root if exists $T->{ pool }->{ $root };
                    }
                }
           );
}

# strongly_connected_components
#
#       @S = $G->strongly_connected_components
#
#       Zwraca silnie spojne skladowe @S grafu $G w postaci anonimowych 
#       list wierzcholkow, z ktorych kazda zawierac bedzie wierzcholki
#       nalezace do jednego silnie spojnej skladowej grafu.
#
sub strongly_connected_components {
    my $G = shift;
    my $T = $G->_strongly_connected;
    my %R = $T->vertex_roots;
    my @C;

    # Laczymy razem wierzcholki majace ten sam wierzcholek bazowy. 
    while (my ($v, $r) = each %R) { push @{ $C[$r] }, $v }

    return @C;
}

# strongly_connected_graph
#
#       $T = $G->strongly_connected_graph
#
#       Zwraca silnie spojny graf $T grafu $G. Nazwy silnie spojnych
#       skladowych sa budowane z tworzacych je wierzcholkow przez
#       proste polaczenie liter znakiem '+', w efekcie "a" i "b"
#       dadza skladowa "a+b".
#
sub strongly_connected_graph {
    my $G = shift;
    my $C = (ref $G)->new;
    my $T = $G->_strongly_connected;
    my %R = $T->vertex_roots;
    my @C; # Nie przyzywamy metody strongly_connected_components()
           # bo potrzebne nam beda rowniez %R.

    # Tworzymy silnie spojne skladowe grafu.
    while (my ($v, $r) = each %R) { push @{ $C[$r] }, $v }
    foreach my $c (@C)            { $c = join("+", @$c)  }

    $C->directed( $G->directed );

    my @E = $G->edges;

    # Kopiujemy krawedzie miedzy silnie spojnymi skladowymi.
    while (my ($u, $v) = splice(@E, 0, 2)) {
        $C->add_edge( $C[ $R{ $u } ], $C[ $R{ $v } ] )
            unless $R{ $u } == $R{ $v };
    }

    return $C;
}

use Graph::Directed;

my $g = Graph::Directed->new();
$g->add_edges(qw(a b  a c  b c  c e  c d  d a  d g
                 e f  f e  f i  g h  h i  i g));

print $g->strongly_connected_graph, "\n";

