# Wymaga modulu Heap::Fibonacci z www.perl.com/CPAN/modules/by-module/Heap

# $finalna_pozycja = wybor_i_ograniczenia( $startowa_pozycja )
sub wybor_i_ograniczenia {
    my $position;

    use Heap::Fibonacci;

    my $pozycje = Heap::Fibonacci->new;

    $pozycje->add( shift );

    while ( $position = $pozycje->extract_minimum ) {
        return $position if $position->to_odpowiedz;

        # To nie byla wlasciwa odpowiedz.
        # Tak wiec wyprobujemy wszystkie pozycje stad osiagalne.
        $position->przygotuj_wyniki;
        my $ruch;
        while ( $ruch = $position->nastepny_ruch ) {
            $pozycje->add( $position->wykonaj_ruch($ruch) );
        }
    }
    # Nie znaleziono odpowiedzi.
    return undef;
}
