#!/usr/bin/perl

# $wartosc = tabeladaty( $tabela, $data )
# tabeladaty( $tabela, $data, $nowa_wartosc )
#
# Przegladamy (i moze zminiamy) indeks wartosci wedlug daty.
# Data ma format "rrrrmmdd", rok(1990-), miesiac(1-12),
# dzien(1-31).

sub tabeladaty {
    my ($tab, $data, $wartosc) = @_;
    my ($rok, $miesiac, $dzien) = ($data =~ /^(\d\d\d\d)(\d\d)(\d\d)$/)
        or die "Niewlasciwy format $data";

    $rok -= 1990;
    --$miesiac; --$dzien;
    if (@_ < 3) {
        return $tab->[$rok][$miesiac][$dzien];
    } else {
        return $tab->[$rok][$miesiac][$dzien] = $wartosc;
    }
}

my $tabela = [];

tabeladaty($tabela, "19990821", "Publikacja ksiazki z wilkiem");
tabeladaty($tabela, "19990923", "Przygotowanie tego przykladu");
print tabeladaty($tabela, "19990923"), " 23 sierpnia, 1999.\n";
