sub proporcjonalne_binarne_przeszukiwanie_lancuchow{
    my ($tablica, $szukany) = @_;

    # $poczatek to pierwszy element, ktory nie jest za niski.
    # $koniec to pierwszy element, ktory nie jest za wysoki.
    # $wspolny to indeks ostatniego znaku testowanego dla     
    #    sprawdzania rownosci elementow $poczatek-1 i $koniec.
    #    Zamiast porownywac caly lancuch, zatrymujemy sie
    #    na "pierwszym innym znaku".
    #    Zaczynamy od pozycji -1, aby znak na pozycji
    #    0 tez byl porownywany.
    #
    my ( $poczatek, $koniec, $wspolny ) = ( 0, scalar(@$tablica), -1 );

    return 0 if $koniec == -1 || $tablica->[0] ge $szukany;
    return $koniec if $tablica->[$koniec-1] lt $szukany;
    --$koniec;

    my ($poczatek_zn,  $koniec_zn,  $szuk_zn ) = (0, 0);
    my ($poczatek_porz, $koniec_porz, $szuk_porz);

    # Sprawdzamy tak dlugo, dopoki sa elementy, ktore moglyby pasowac.
    #
    while( $poczatek < $koniec ) {
        if ($poczatek_zn eq $koniec_zn) {
            while ($poczatek_zn eq $koniec_zn) {
                return $poczatek if $wspolny == length($tablica->[$koniec]);
                ++$wspolny;
                $poczatek_zn  = substr( $tablica->[$poczatek],  $wspolny, 1 );
                $koniec_zn = substr( $tablica->[$koniec], $wspolny, 1 );
            }
            $szuk_zn = substr( $szukany, $wspolny, 1 );
            $poczatek_porz  = ord( $poczatek_zn  );
            $koniec_porz = ord( $koniec_zn );
            $szuk_porz = ord( $szuk_zn );
        }
        # Sprawdzamy odpowiedni proporcjonalny element (kod powyzej
        # upewnial sie, ze proporcjonalny element szukany jest w 
        # istniejacym - niezerowym - przedziale).

        my $biez = $poczatek;
        $biez += int( ($koniec - 1 - $poczatek) * ($szuk_porz - $poczatek_porz)
                        / ($koniec_porz - $poczatek_porz) );
        my $nowy_zn = substr( $tablica->[$biez], $wspolny, 1 );
        my $nowy_porz = ord( $nowy_zn );

        if ($nowy_porz < $szuk_porz
                || ($nowy_porz == $szuk_porz
                    && $tablica->[$biez] lt $szukany) ) {
            $poczatek  = $biez+1;       # za maly, szukamy wyzej
            $poczatek_zn  = substr( $tablica->[$poczatek], $wspolny, 1 );
            $poczatek_porz = ord( $poczatek_zn );
        } else {
            $koniec = $biez;         # nie za maly, szukamy nizej
            $koniec_zn  = $nowy_zn;
            $koniec_porz = $nowy_porz;
        }
    }
    return $poczatek;
}

@tablica = qw(adaks bizon chomik dingo ent faerie ghoul hipopotam
	    indyk jemioluszka kookaburra lemur mag narn orzel
	    papuga quetzalcoatl rastafarianin sowa tygrys urwis vywern
	    wieloryb xorn yeti zoolog);


print proporcjonalne_binarne_przeszukiwanie_lancuchow(\@tablica, "urwis"), "\n";



