#!/usr/bin/perl

use kolko_i_krzyzyk;

# Stosowanie:
#    Aby zminimalizowac kolejny ruch:
#        ($ruch,$wynik) = ab_minimaks($pozycja,$glebokosc)
#    Dostarczamy obiektu pozycji i maksymalnej glebokosci
#    (liczby ruchow) badanych, zanim zostanie przerwane
#    genrowanie ruchow i pozycja zostanie poddana ocenie.

sub ab_minimaks {
    my ( $pozycja, $glebokosc, $alfa, $beta ) = @_;

    defined ($alfa) or $alfa = -$pozycja->najlepszy_wynik;
    defined ($beta)  or $beta  =  $pozycja->najlepszy_wynik;

    # Czy zaszlismy tak gleboko jak bylo mozna lub jak bylo trzeba?
    if ( $glebokosc-- and defined($pozycja->przygotuj_ruchy) ) {
        # nie, wykonuj nastepne ruchy mozliwe z $pozycja
        my $ruch;
        my $najlepsza_ocena = -$pozycja->najlepszy_wynik;
        my $najlepsza_kol_ruchow;
        my $alfa_biez = $alfa;

        while ( defined($ruch = $pozycja->nastepny_ruch) ) {
            # Oceniamy nastepny ruch.
            my ( $ta_kol_ruchow, $ta_ocena ) =
                ab_minimaks( $pozycja->wykonaj_ruch($ruch),
                                $glebokosc, -$beta, -$alfa_biez );
            # Wynik przeciwnika ma odwrotna wartosc niz nasz.
            $ta_ocena = -$ta_ocena;
            if ( $ta_ocena > $najlepsza_ocena ) {
                $najlepsza_ocena = $ta_ocena;
                $alfa_biez = $najlepsza_ocena if $najlepsza_ocena > $alfa_biez;
                $najlepsza_kol_ruchow = $ta_kol_ruchow;
                unshift ( @$najlepsza_kol_ruchow, $ruch );

                # Tu wykonujemy odcinanie alfa-beta.
                #    - rezygnujemy, jesli ktos jest lepszy!
                last if $najlepsza_ocena >= $beta;
            }
        }

        # Zwracamy najlepsze, co znalezlismy.
        return ( $najlepsza_kol_ruchow, $najlepsza_ocena );

    } else {
        # Tak - oceniamy biezaca pozycje, a nie ruch do wykonania.
        return ( [ $pozycja ], -$pozycja->oceniaj );
    }
}

my $gra = kolko_i_krzyzyk->new( );

my ( $ruchy, $wynik ) = ab_minimaks( $gra, 2 );
my $moj_ruch = $ruchy->[0];
print "Moj ruch: $moj_ruch\n";
