#!/usr/bin/perl

sub min { # Liczby.
    my $min = shift;
    foreach ( @_ ) { $min = $_ if $_ < $min }
    return $min;
}

sub smin { # Lancuchy.
    my $s_min = shift;
    foreach ( @_ ) { $s_min = $_ if $_ lt $s_min }
    return $smin;
}

sub gmin { # Uniwersalne.
    my $g_cmp = shift;
    my $g_min = shift;
    foreach ( @_ ) { $g_min = $_ if $g_cmp->( $_, $g_min ) < 0 }
    return $g_min;
}

sub max { # Liczby.
    my $max = shift;
    foreach ( @_ ) { $max = $_ if $_ > $max }
    return $max;
}

sub smax { # Lancuchy.
    my $s_max = shift;
    foreach ( @_ ) { $s_max = $_ if $_ gt $s_max }
    return $s_max;
}

sub gmax { # Uniwersalne.
    my $g_cmp = shift;
    my $g_max = shift;
    foreach ( @_ ) { $g_max = $_ if $g_cmp->( $_, $g_max ) > 0 }
    return $g_max;
}

sub mini {
    my $l = $_[ 0 ];
    my $n = @{ $l };
    return ( ) unless $n;        # Rezygnujemy, jesli nie ma listy.
    my $v_min = $l->[ 0 ];       # Inicjujemy indeksy.
    my @i_min = ( 0 );

    for ( my $i = 1; $i < $n; $i++ ) {
        if ( $l->[ $i ] < $v_min ) {
            $v_min = $l->[ $i ]; # Aktualizujemy minimum
            @i_min = ( $i );     # i resetujemy indeksy.
        } elsif ( $l->[ $i ] == $v_min ) {
            push @i_min, $i;     # Zbieramy indeksy minimum.
        }
    }

    return @i_min;
}

sub maxi {
    my $l = $_[ 0 ];
    my $n = @{ $l };
    return ( ) unless $n;        # Rezygnujemy, jesli nie ma listy.
    my $v_max = $l->[ 0 ];       # Inicjujemy indeksy.
    my @i_max = ( 0 );

    for ( my $i = 1; $i < $n; $i++ ) {
        if ( $l->[ $i ] > $v_max ) {
            $v_max = $l->[ $i ]; # Aktualizujemy maksimum and
            @i_max = ( $i );     # przywracamy indeksy.
        } elsif ( $l->[ $i ] == $v_max ) {
            push @i_max, $i;     # Zbieramy indeksy maksimum.
        }
    }

    return @i_max;
}

sub gextrem {
   my $g_cmp = $_[ 0 ];
   my $l     = $_[ 1 ];
   my $n     = @{ $l };
   return ( ) unless $n;                # Rezygnujemy, jesli nie ma listy.
   my $v_min = $l->[ 0 ];
   my $v_max = $v_min;                  # Dotychczasowe maksimum.
   my @i_min = ( 0 );                   # Indeksy minimum.
   my @i_max = ( 0 );                   # Indeksy maksimum.
   my $v_cmp;                           # Wynik porownania.

   for ( my $i = 1; $i < $n; $i++ ) {
       $v_cmp = $g_cmp->( $l->[ $i ], $v_min );
       if ( $v_cmp < 0 ) {
           $v_min = $l->[ $i ];         # Aktualizujemy minimum i resetujemy minima.
           @i_min = ( $i );
       } elsif ( $v_cmp == 0 ) {
           push @i_min, $i ;            # Zbieramy minima w razie potrzeby.
       } else {                         # Nie minimum: moze maximum?
           $v_cmp = $g_cmp->( $l->[ $i ], $v_max );
           if ( $v_cmp > 0 ) {
               $v_max = $l->[ $i ];     # Aktualizujemy maksimum i resetujemy maksima.
               @i_max = ( $i );
           } elsif ( $v_cmp == 0 ) {
               push @i_max, $i;         # Zbieramy maksima.
           }
        }                               # Ani minimum ani maksimum.
    }
    return ( \@i_min, \@i_max );
}

my @x = qw(31 41 59 26 59 26 35 89 35 89 79 32);

my @i_max = maxi(\@x);    # @i_max teraz powinna zawierac 7 i 9.
print "@i_max\n";

#        0  1  2  3  4  5  6  7  8  9 10 11
@x = qw(31 41 59 26 59 26 35 89 35 89 79 32);

my ($i_min, $i_max) = gextrem(sub { $_[0] <=> $_[1] }, \@x);

# @$i_min teraz zawiera 3 i 5.
# @$i_max teraz zawiera 7 i 9.

print "i_min: @$i_min\n";
print "i_max: @$i_max\n";
