#!/usr/bin/perl

use constant ROZMIAR_POJEMNIKA => 10;

sub bucket_sort {
    my ($tablica, $min, $max) = @_;
    my $N = @$tablica or return;

    my $zakres     = $max - $min;
    my $N_POJEMNIK = $N / ROZMIAR_POJEMNIKA;
    my @pojemnik;

    # Tworzenie pojemnikow.
    for ( my $i = 0; $i < $N_POJEMNIK; $i++ ) {
        $pojemnik[ $i ] = [ ];
    }

    # Napelnianie pojemnikow.
    for ( my $i = 0; $i < $N; $i++ ) {
        my $pojemnik = $N_POJEMNIK * (($tablica->[ $i ] - $min)/$zakres);
        push @{ $pojemnik[ $pojemnik ] }, $tablica->[ $i ];
    }


    # Sortowanie wewnatrz pojemnikow.
    for ( my $i = 0; $i < $N_POJEMNIK; $i++ ) {
        insertion_sort( $pojemnik[ $i ] );
    }

    # Sklejanie pojemnikow.

    @{ $tablica } = map { @{ $_ } } @pojemnik;
}

sub insertion_sort {
    my $tablica = shift;

    my $i;      # Poczatkowy indeks dla elementu minimum.
    my $j;      # Biezacy indeks dla operacji odszukiwania minimum.

    for ( $i = 0; $i < $#$tablica; $i++ ) {
        my $m = $i;               # Koncowy indeks dla elementu minimum.
        my $x = $tablica->[ $m ]; # Wartosc minimum.

        for ( $j = $i + 1; $j < @$tablica; $j++ ) {
            ( $m, $x ) = ( $j, $tablica->[ $j ] ) # Aktualizacja minimum.
              if $tablica->[ $j ] lt $x;
        }

        # Podwojna operacja splice po prostu przenosi $m-ty element 
        # na $i-th element. Uwaga: koszt splice to O(N), nie O(1).
        # Tak dlugo, jak dlugo rozwazamy zlozonosc czasowa algorytmu,
        # nie ma roznicy, czy przenosimy blok tablicy uzywajac 
        # petli, czy uzywajac splice(). Nadal funkcja, splice()
        # jest szybsza niz przenoszenie bloku element po elemencie.
        splice @$tablica, $i, 0, splice @$tablica, $m, 1 if $m > $i;
    }
}

@tablica = qw(1 8 7 4 0 9 8 3 7 1 6 8 1 1 8 7 6 4 4 8 9 4 0 3 9 3 2 3 9);

bucket_sort(\@tablica, 0, 9);

print "@tablica\n";