﻿class Graph {
	private var x_max:Number;
	private var x_min:Number;
	private var y_max:Number;
	private var y_min:Number;
	private var num_points_x:Number;
	private var num_points_y:Number;
	private var zoom:Number;
	private var increment_x:Number;
	private var increment_y:Number;
	private var origin_x:Number;
	private var origin_y:Number;
	private var rotate_x:Number;
	private var rotate_y:Number;
	private var sin_x:Number;
	private var cos_x:Number;
	private var sin_y:Number;
	private var cos_y:Number;
	private var points:Array;
	private var trans:Number = Math.PI/180;
	//
	// obiekt typu graph -- kreślenie nowego wykresu
	// PARAMETRY
	// równanie - odwołanie do funkcji, która po przekazaniu do niej dwóch argumentów ("x" i "y") zwraca określoną wartość
	// x_max, x_min, y_max, y_min - wymiary okna wykresu
	// num_points_x, num_points_y - liczba punktów, które mają być narysowane wzdłuż osi x i y
	// zoom - współczynnik powiększenia ... zmiana jego wartości może poprawić czytelność wykresu
	// rotate_x, rotate_y - położenie wykresu
	// center_x, center_y - środek układu współrzędnych na scenie Flasha
	function Graph(x_max:Number, x_min:Number, y_max:Number, y_min:Number, num_points_x:Number, num_points_y:Number, zoom:Number, rotate_x:Number, rotate_y:Number, origin_x:Number, origin_y:Number) {
		// prostokątny obszar, ponad którym będzie narysowany wykres -- D = {(x, y) | x_min < x < x_max, y_min < y < y_max}
		this.x_max = x_max;
		this.x_min = x_min;
		this.y_max = y_max;
		this.y_min = y_min;
		// liczba punktów, które zostaną rozmieszczone wzdłuż osi x i y
		this.num_points_x = num_points_x;
		this.num_points_y = num_points_y;
		// współczynnik powiększenia
		this.zoom = zoom;
		// przyrosty względem osi x i y
		this.increment_x = (this.x_max-this.x_min)/this.num_points_x;
		this.increment_y = (this.y_max-this.y_min)/this.num_points_y;
		// położenie początku układu współrzędnych
		this.origin_x = origin_x;
		this.origin_y = origin_y;
		// położenie wykresu na osi x i y
		this.rotate_x = rotate_x;
		this.rotate_y = rotate_y;
		// sinus i cosinus kątów obrotu
		sin_x = Math.sin(this.rotate_x*trans);
		cos_x = Math.cos(this.rotate_x*trans);
		sin_y = Math.sin(this.rotate_y*trans);
		cos_y = Math.cos(this.rotate_y*trans);
	}
	//
	// rozciągnięcie klipu "mc" w celu połączenia punktów o współrzędnych (x1, y1) i (x2, y2) -- zmienna "mc" powinna zawierać pełną ścieżkę dostępu do tego klipu
	private function draw_line(mc:MovieClip, x1:Number, y1:Number, x2:Number, y2:Number) {
		mc._x = x1;
		mc._y = y1;
		mc._xscale = x2-x1;
		mc._yscale = y2-y1;
	}
	//
	// funkcja wielu zmiennych, opierająca się na wartościach "x" and "y" --- od zwracanej wartości zależy kształt kreślonego wykresu
	// UWAGA: posługując się funkcjami trygonometrycznymi, należy pomnożyć wyrażenia w nawiasach przez zmienną "trans", by dokonać przeliczenia stopni na radiany
	private function function_xy(x:Number, y:Number) {
		return (4*Math.sin((x*y-x*x+y*y)*trans));
	}
	//
	// kreślenie wykresu 3d z = f(x, y)
	public function plot() {
		// obliczenie współrzędnych punktów na wykresie
		calculate_points();
		// połączenie wszystkich punktów liniami, tworzącymi siatkę
		draw_grid();
	}
	//
	// połączenie wszystkich punktów liniami, tworzącymi siatkę
	private function draw_grid() {
		// współrzędne dwóch punktów, które zostaną połączone linią
		var x1:Number;
		var y1:Number;
		var x2:Number;
		var y2:Number;
		//
		_root.clear();
		_root.lineStyle(1, 0x00ff00, 100);
		// wygenerowanie pionowych linii dla wszystkich par punktów
		for (var j = 1; j<num_points_x+1; j++) {
			for (var k = 0; k<=num_points_y; k++) {
				// znajdź dwa punkty, które ma połączyć linia
				x1 = points[j][k].perspective_x;
				y1 = points[j][k].perspective_y;
				x2 = points[j-1][k].perspective_x;
				y2 = points[j-1][k].perspective_y;
				// połącz znalezione punkty linią
				_root.moveTo(x1, y1);
				_root.lineTo(x2, y2);
			}
		}
		//
		// wygenerowanie poziomych linii dla wszystkich par punktów
		for (var j = 0; j<=num_points_x; j++) {
			for (var k = 1; k<=num_points_y; k++) {
				// znajdź dwa punkty, które ma połączyć linia
				x1 = points[j][k].perspective_x;
				y1 = points[j][k].perspective_y;
				x2 = points[j][k-1].perspective_x;
				y2 = points[j][k-1].perspective_y;
				//
				// połącz znalezione punkty linią
				_root.moveTo(x1, y1);
				_root.lineTo(x2, y2);
			}
		}
	}
	//
	// obliczenie współrzędnych punktów, które mają być wyświetlone na ekranie
	private function calculate_points() {
		// dwuwymiarowa tablica obiektów, która zawiera współrzędne wszystkich punktów
		points = new Array();
		//
		// przejrzyj wszystkie współrzędne x
		for (var j = 0; j<=num_points_x+1; j++) {
			// dodaj kolejny wymiar do tablicy
			points[j] = new Array();
			// przejrzyj wszystkie współrzędne y
			for (var k = 0; k<=num_points_y; k++) {
				// utwórz nowy obiekt na podstawie elementów tablicy, w celu obliczenia współrzędnych punktu w przestrzeni (x,y,z)
				points[j][k] = new Object();
				// obliczenie współrzędnych punktu
				points[j][k].x = index_to_coord("x", j);
				points[j][k].y = index_to_coord("y", k);
				points[j][k].z = function_xy(points[j][k].x, points[j][k].y);
				// przeliczenie współrzędnych punktu w układzie współrzędnych Flasha, na zwykły układ kartezjański
				exchange_point(j, k);
				// obróć punkt względem osi x i y
				rotate_point(j, k);
				// powiększ wykres
				scale_point(j, k);
				// zastosuj odpowiednią perspektywę
				perspective_point(j, k);
				// przelicz punkt względem początku układu współrzędnych
				translate_point(j, k);
			}
		}
	}
	// zamień wartości (j, k) pobrane z tablicy na współrzędne (x, y) na wykresie
	private function index_to_coord(determine:String, index:Number) {
		return (index*this["increment_"+determine]+this[determine+"_min"]);
	}
	//
	// zmiana okna wykresu
	public function change_window(x_max:Number, x_min:Number, y_max:Number, y_min:Number, z_max:Number, z_min:Number) {
		// aktualizacja wymiarów okna
		this.x_max = Number(x_max);
		this.x_min = Number(x_min);
		this.y_max = Number(y_max);
		this.y_min = Number(y_min);
		// aktualizacja przyrostu wartości względem osi x i y
		increment_x = (this.x_max-this.x_min)/num_points_x;
		increment_y = (this.y_max-this.y_min)/num_points_y;
	}
	// zmiana liczby punktów, które mają być wykreślone względem osi x i y
	public function change_num_points(num_points_x:Number, num_points_y:Number) {
		// zmiana liczby punktów, które mają być wykreślone względem osi x i y
		this.num_points_x = Number(num_points_x);
		this.num_points_y = Number(num_points_y);
		// aktualizacja przyrostu wartości względem osi x i y
		increment_x = (this.x_max-this.x_min)/this.num_points_x;
		increment_y = (this.y_max-this.y_min)/this.num_points_y;
	}
	//
	// zmiana współczynnika powiększenia
	public function change_zoom(zoom:Number) {
		this.zoom = Number(zoom);
	}
	//
	// zmiana kąta obrotu
	public function change_rotation(rotate_x:Number, rotate_y:Number) {
		this.rotate_x = Number(rotate_x);
		this.rotate_y = Number(rotate_y);
		// aktualizacja wartości sinusa i cosinusa kąta obrotu
		calculate_sine_cosine();
	}
	//
	// przeliczenie współrzędnych punktu w układzie współrzędnych Flasha, na zwykły układ kartezjański
	private function exchange_point(a:Number, b:Number) {
		// deklaracja zmiennych przechowujących współrzędne punktu w przestrzeni
		var x:Number;
		var y:Number;
		var z:Number;
		// pobranie współrzędnych
		x = points[a][b].x;
		y = points[a][b].y;
		z = points[a][b].z;
		// przeliczenie pomiędzy układem współrzędnych Flasha, a kartezjańskim
		points[a][b].x = y;
		points[a][b].y = z;
		points[a][b].z = x;
	}
	//
	// obrót punktu (przekazanego w postaci obiektu) o "a" i "b" względem osi x i y
	private function rotate_point(a:Number, b:Number) {
		// współrzędne 3d punktu do obrócenia
		var x:Number;
		var y:Number;
		var z:Number;
		// pomocnicze współrzędne obrotu
		var rx1:Number;
		var ry1:Number;
		var rz1:Number;
		var rx2:Number;
		var ry2:Number;
		var rz2:Number;
		// pobierz współrzędne punktu w przestrzeni
		x = points[a][b].x;
		y = points[a][b].y;
		z = points[a][b].z;
		// obróć punkt względem osi y
		rx1 = x*cos_y-z*sin_y;
		ry1 = y;
		rz1 = z*cos_y+x*sin_y;
		// obróć punkt względem osi x
		rx2 = rx1;
		ry2 = ry1*cos_x-rz1*sin_x;
		rz2 = rz1*cos_x+ry1*sin_x;
		// zaktualizuj wartości w tablicy współrzędnych
		points[a][b].x = rx2;
		points[a][b].y = ry2;
		points[a][b].z = rz2;
	}
	//
	// skalowanie wykresu -- "powiększanie"
	private function scale_point(a:Number, b:Number) {
		points[a][b].x *= zoom;
		points[a][b].y *= zoom;
		points[a][b].z *= zoom;
	}
	//
	// zmiana współrzędnych w przestrzeni 3D na parę współrzędnych ekranowych
	private function perspective_point(a:Number, b:Number) {
		// obliczanie perspektywy -- odległość od punktu obserwacji do ekranu
		var D:Number = 500;
		// współczynnik perspektywy -- służy do przeliczenia współrzędnych trójwymiarowych na dwuwymiarowe
		var perspective_ratio:Number;
		// jeśli punkt jest widoczny, oblicz jego położenie na ekranie
		if (points[a][b].z>-D) {
			// uwzględnij perspektywę
			perspective_ratio = D/(points[a][b].z+D);
			// oblicz współrzędne punktu na ekranie
			points[a][b].perspective_x = perspective_ratio*points[a][b].x;
			points[a][b].perspective_y = perspective_ratio*points[a][b].y;
		} else {
			// punkt znajduje się za obserwatorem, więc nie powinien być widoczny
			points[a][b].perspective_x = null;
			points[a][b].perspective_y = null;
		}
	}
	//
	// przeliczeniw współrzędnych w taki sposób, by uwzględniały początek układu współrzędnych podany przez użytkownika
	private function translate_point(a:Number, b:Number) {
		points[a][b].perspective_x = origin_x+points[a][b].perspective_x;
		points[a][b].perspective_y = origin_y-points[a][b].perspective_y;
	}
	//
	// obliczenie sinusa i cosinusa kątów obrotu
	private function calculate_sine_cosine() {
		sin_x = Math.sin(rotate_x*trans);
		cos_x = Math.cos(rotate_x*trans);
		sin_y = Math.sin(rotate_y*trans);
		cos_y = Math.cos(rotate_y*trans);
	}
}
