import matplotlib.pyplot as plt
import numpy as np

from multiprocessing import cpu_count

from sklearn.datasets import load_wine
from sklearn.ensemble import RandomForestClassifier
from sklearn.feature_selection import SelectFromModel
from sklearn.model_selection import cross_val_score
from sklearn.linear_model import LogisticRegression
from sklearn.tree import DecisionTreeClassifier
from sklearn.svm import SVC

# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


if __name__ == '__main__':
    # Wczytuje zestaw danych
    X, Y = load_wine(return_X_y=True)

    # Testuje regresję logistyczną
    lr = LogisticRegression(max_iter=1000, random_state=1000)
    print('Wynik CV dla regresji logistycznej: {}'.format(np.mean(cross_val_score(lr, X, Y, cv=10))))

    # Testuje drzewo decyzyjne
    dt = DecisionTreeClassifier(criterion='entropy', random_state=1000)
    print('Wynik CV dla drzewa decyzyjnego: {}'.format(np.mean(cross_val_score(dt, X, Y, cv=10))))

    # Testuje wielomianową maszynę SVM
    svm = SVC(kernel='poly', random_state=1000)
    print('Wynik CV dla wielomianowej maszyny SVM: {}'.format(np.mean(cross_val_score(svm, X, Y, cv=10))))

    # Testuje las losowy
    rf = RandomForestClassifier(n_estimators=50, n_jobs=cpu_count(), random_state=1000)
    scores = cross_val_score(rf, X, Y, cv=10)
    print('Wynik CV dla lasu losowego: {}'.format(np.mean(scores)))

    # Tworzy wykres wyników CV
    fig, ax = plt.subplots(figsize=(15, 7))

    ax.plot(scores)
    ax.set_xlabel('Liczba drzew (x10)')
    ax.set_ylabel('Dokładność 10-krotnego sprawdzianu krzyżowego')
    ax.grid()
    plt.show()

    # Ukazuje istotności cech
    rf.fit(X, Y)

    wine = load_wine()
    features = [wine['feature_names'][x] for x in np.argsort(rf.feature_importances_)][::-1]

    fig, ax = plt.subplots(figsize=(15, 8))

    ax.bar([i for i in range(13)], np.sort(rf.feature_importances_)[::-1], align='center')
    ax.set_ylabel('Istotność cechy')
    plt.xticks([i for i in range(13)], features, rotation=60)
    plt.show()

    # Wybiera najistotniejsze cechy
    sfm = SelectFromModel(estimator=rf, prefit=True, threshold=0.02)
    X_sfm = sfm.transform(X)

    print('Wymiary doboru cech: {}'.format(X_sfm.shape))

