import matplotlib.pyplot as plt
import numpy as np

from sklearn.datasets import fetch_mldata
from sklearn.decomposition import PCA

# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


def zero_center(Xd):
    return Xd - np.mean(Xd, axis=0)


if __name__ == '__main__':
    # Wczytuje zestaw danych
    digits = fetch_mldata('MNIST original')
    X = zero_center(digits['data'].astype(np.float64))
    np.random.shuffle(X)

    # Tworzy zestaw danych + szum heteroskedatyczny
    Omega = np.random.uniform(0.0, 0.75, size=X.shape[1])
    Xh = X + np.random.normal(0.0, Omega, size=X.shape)

    # Wyświetla zestaw danych + szum heteroskedatyczny
    fig, ax = plt.subplots(10, 10, figsize=(10, 10))

    for i in range(10):
        for j in range(10):
            ax[i, j].imshow(Xh[(i * 10) + j].reshape((28, 28)), cmap='gray')
            ax[i, j].axis('off')

    plt.show()

    # Przeprowadza analizę PCA na zestawie danych + szumie heteroskedatycznym
    pca = PCA(n_components=64, svd_solver='full', random_state=1000)
    Xpca = pca.fit_transform(Xh)

    print('Wynik analizy PCA: {}'.format(pca.score(Xh)))
    print('Współczynnik wariancji wyjaśnionej: {}'.format(np.sum(pca.explained_variance_ratio_)))

    # Tworzy wykres współczynnika wariancji wyjaśnionej
    ev = pca.explained_variance_ratio_

    fig, ax = plt.subplots(figsize=(10, 6))

    ax.bar(np.arange(0, len(ev), 1), ev)
    ax.set_xlabel('Składowe')
    ax.set_ylabel('Współczynnik wariancji wyjaśnionej')

    plt.show()


