import matplotlib.pyplot as plt
import numpy as np

from sklearn.datasets import make_classification
from sklearn.linear_model import LogisticRegression
from sklearn.model_selection import cross_val_score


# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


if __name__ == '__main__':
    # Tworzy zestaw danych
    X, Y = make_classification(n_samples=1000, random_state=1000)

    # Realizuje sprawdzian krzyżowy za pomocą 15 grup i regresji logistycznej
    score = cross_val_score(LogisticRegression(), X, Y, cv=15)

    print('Średni wynik sprawdzianu krzyżowego: {}'.format(np.mean(score)))
    print('Wariancja wyniku sprawdzianu krzyżowego: {}'.format(np.var(score)))

    # Rysuje wykresy
    fig, ax = plt.subplots(figsize=(10, 6))

    ax.plot(score)
    ax.set_xlabel('Grupa sprawdzianu krzyżowego')
    ax.set_ylabel('Dokładność regresji logistycznej')
    ax.grid()
    plt.show()