
# Symbole reprezentujące człowieka i sztuczną inteligencję.
PLAYER_HUMAN = 'H'
PLAYER_AI = 'A'
BOARD_EMPTY_SLOT = '_'
WINNING_SEQUENCE_COUNT = 4

# Krotka, gdzie człowiek jest zakodowany jako -1, a sztuczna inteligencja jako 1.
PLAYERS = {PLAYER_HUMAN: -1,
           PLAYER_AI: 1}


# Klasa z logiką gry czwórki.
class Connect:

    # Plansza jest inicjowana na podstawie wymiarów x i y.
    def __init__(self, board_size_x=5, board_size_y=4):
        self.board_size_x = board_size_x
        self.board_size_y = board_size_y
        self.player_turn = PLAYERS[PLAYER_AI]
        self.board = self.generate_board(board_size_x, board_size_y)

    # Resetowanie gry (opróżnianie planszy).
    def reset(self):
        self.board = self.generate_board(self.board_size_x, self.board_size_y)

    # Generowanie pustej planszy w celu rozpoczęcia gry po resecie.
    def generate_board(self, board_size_x, board_size_y):
        board = []
        for x in range(board_size_x):
            row = BOARD_EMPTY_SLOT * board_size_y
            board.append(row)
        return board

    # Wyświetlanie planszy w konsoli.
    def print_board(self):
        result = ''
        for y in range(0, self.board_size_y):
            for x in range(0, self.board_size_x):
                result += self.board[x][y]
            result += '\n'
        print(result)

    # Wyświetlanie, kto ma ruch.
    def print_turn(self):
        if self.player_turn == PLAYERS[PLAYER_HUMAN]:
            print('Ruch gracza')
        else:
            print('Ruch sztucznej inteligencji')

    # Określanie, kto wygrał.
    def has_winner(self):
        if self.has_a_row(PLAYER_HUMAN, WINNING_SEQUENCE_COUNT):
            return "Wygrał człowiek"
        elif self.has_a_row(PLAYER_AI, WINNING_SEQUENCE_COUNT):
            return "Wygrała sztuczna inteligencja"
        return 0

    # Ustalanie wartości dla sztucznej inteligencji.
    def get_score_for_ai(self):
        if self.has_a_row(PLAYER_HUMAN, 4):
            return -10
        if self.has_a_row(PLAYER_AI, 4):
            return 10
        return 0

    # Określanie, czy gracz może ułożyć czwórkę.
    def has_a_row(self, player, row_count):
        for x in range(self.board_size_x):
            for y in range(self.board_size_y):
                if self.has_row_of_x_from_point(player, row_count, x, y, 1, 0):  # Poziomo.
                    return True
                elif self.has_row_of_x_from_point(player, row_count, x, y, 0, 1):  # Pionowo.
                    return True
                elif self.has_row_of_x_from_point(player, row_count, x, y, 1, 1):  # Przekątna.
                    return True
        return False

    # Określanie, czy gracz może ułożyć czwórkę w danym punkcie.
    def has_row_of_x_from_point(self, player, row_count, x, y, offset_x, offset_y):
        total = 0
        for i in range(row_count):
            target_x = x + (i * offset_x)
            target_y = y + (i * offset_y)
            if self.is_within_bounds(target_x, target_y):
                if self.board[target_x][target_y] == player:
                    total += 1
        if total == row_count:
            return True
        return False

    # Określa, czy dana para x,y znajduje się na planszy.
    def is_within_bounds(self, x, y):
        if 0 <= x < self.board_size_x and 0 <= y < self.board_size_y:
            return True
        return False

    # Określa, czy cała plansza jest zapełniona żetonami.
    def is_board_full(self):
        for x in range(self.board_size_x):
            if BOARD_EMPTY_SLOT in self.board[x]:
                return False
        return True

    # Określa, czy pole jest zapełnione.
    def is_slot_full(self, slot_number):
        if BOARD_EMPTY_SLOT in self.board[slot_number]:
            return False
        return True

    # Określa, czy pole jest puste.
    def is_slot_empty(self, slot_number):
        count = 0
        for i in range(self.board_size_y):
            if self.board[slot_number][i] == BOARD_EMPTY_SLOT:
                count += 1
        if count == self.board_size_y:
            return True
        return False

    # Wykonywanie ruchu gracza.
    def execute_move(self, player, slot_number):
        row = self.board[slot_number]
        # Umieszczanie żetonu w dolnym rzędzie, jeśli pole jest puste.
        if self.is_slot_empty(slot_number):
            self.board[slot_number] = row[0:self.board_size_y - 1] + player
        else:
            # Umieszczanie żetonu w pierwszym wolnym rzędzie, jeśli dane pole nie jest puste.
            for i in range(0, self.board_size_y - 1):
                if row[i + 1] != BOARD_EMPTY_SLOT:
                    self.board[slot_number] = row[0:i] + player + row[i + 1:]
                    break

    # Wykonywanie ruchu gracza, jeśli pole jest wolne, i ustalanie, na kogo przypada ruch.
    def play_move(self, slot):
        if 0 <= slot <= 4:
            if not self.is_slot_full(slot):
                if self.player_turn == PLAYERS[PLAYER_AI]:
                    self.execute_move(PLAYER_AI, slot)
                else:
                    self.execute_move(PLAYER_HUMAN, slot)
                self.player_turn *= -1
                return True
            return False
        return False
