import maze_puzzle as mp


# Funkcja znajdująca trasę za pomocą algorytmu przeszukiwania w głąb.

# Przeszukiwanie w głąb to następny algorytm używany do przechodzenia drzewa lub generowania węzłów i ścieżek w drzewie. 
# Ten algorytm rozpoczyna od danego węzła i rekurencyjnie analizuje ścieżki powiązanych węzłów pierwszego dziecka do czasu 
# dotarcia do najdalszego liścia; potem cofa się i analizuje kolejne ścieżki do liści prowadzące z innych odwiedzonych dzieci. 

# Choć algorytm przeszukiwania w głąb można zaimplementować za pomocą funkcji rekurencyjnej, tu używana jest implementacja 
# oparta na stosie, ponieważ lepiej ilustruje kolejność odwiedzania i przetwarzania węzłów. Ważne jest, aby zapisywać 
# odwiedzone węzły; pozwala to uniknąć niepotrzebnego ponownego odwiedzania tych samych węzłów i powstawania cykli.
def run_dfs(maze_game, current_point):
    # Umieszczanie bieżącego węzła na stosie.
    visited_points = []
    stack = [current_point]
    # Kontynuowanie przeszukiwania, dopóki występują węzły na stosie.
    while stack:
        # Ustawianie następnego węzła ze stosu jako bieżącego.
        next_point = stack.pop()
        # Jeśli bieżący węzeł nie został jeszcze sprawdzony, należy go zbadać.
        if not is_in_visited_points(next_point, visited_points):
            visited_points.append(next_point)
            # Return the path to the current neighbor if it is the goal
            # Zwracanie ścieżki do bieżącego sąsiada, jeśli jest celem.
            if maze_game.get_current_point_value(next_point) == '*':
                return next_point
            else:
                # Dodawanie sąsiadów bieżącego węzła do stosu.
                neighbors = maze_game.get_neighbors(next_point)
                for neighbor in neighbors:
                    neighbor.set_parent(next_point)
                    stack.append(neighbor)
    return 'Brak ścieżki do celu.'


# Funkcja określająca, czy punkt został już odwiedzony.
def is_in_visited_points(current_point, visited_points):
    for visited_point in visited_points:
        if current_point.x == visited_point.x and current_point.y == visited_point.y:
            return True
    return False


print('--- Przeszukiwanie w głąb ---')

# Inicjowanie obiektu typu MazePuzzle.
maze_game_main = mp.MazePuzzle()

# Uruchamianie algorytmu przeszukiwania w głąb dla zainicjowanego labiryntu.
starting_point = mp.Point(2, 2)
outcome = run_dfs(maze_game_main, starting_point)

# Pobieranie ścieżki znalezionej przez algorytm przeszukiwania w głąb.
dfs_path = mp.get_path(outcome)

# Wyświetlanie informacji o znalezionej ścieżce.
print('Długość ścieżki: ', len(dfs_path))
maze_game_main.overlay_points_on_map(dfs_path)
print('Koszt ścieżki: ', mp.get_path_cost(outcome))
for point in dfs_path:
    print('Punkt: ', point.x, ',', point.y)
