package com.wrox.algorithms.sets;

import com.wrox.algorithms.iteration.EmptyIterator;
import com.wrox.algorithms.iteration.Iterator;

public final class EmptySet implements Set {
    /** pojedyncza publicznie dostpna instancja klasy */
    public static final EmptySet INSTANCE = new EmptySet();

    private EmptySet() {
    }

    public boolean contains(Object value) {
        return false;
    }

    public boolean add(Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean delete(Object value) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public Iterator iterator() {
        return EmptyIterator.INSTANCE;
    }
}
