package com.wrox.algorithms.queues;

import com.wrox.algorithms.iteration.Iterator;
import com.wrox.algorithms.lists.ArrayList;
import com.wrox.algorithms.lists.List;

public class CallCenter {
    /** kolejka zgosze */
    private final Queue _calls = new BlockingQueue(new ListFifoQueue());

    /** liczba dziaajcych konsultantw */
    private final int _numberOfAgents;

    /**  lista wtkw konsultantw 
      */ pusta, gdy centrum zamknite, i niepusta, gdy otwarte
      */
    private final List _threads;

    /**
     * Konstruktor.
     * parametr: liczba dziaajcych konsultantw
     */
    public CallCenter(int numberOfAgents) {
        _threads = new ArrayList(numberOfAgents);
        _numberOfAgents = numberOfAgents;
    }


    public void open() {
        assert _threads.isEmpty() : "Centrum obsugi jest ju otwarte";

        System.out.println("Otwieranie centrum obsugi");

        for (int i = 0; i < _numberOfAgents; ++i) {
            Thread thread = new Thread(new CustomerServiceAgent(i, _calls));

            thread.start();
            _threads.add(thread);
        }

        System.out.println("Centrum obsugi otwarte");
    }


    public void accept(Call call) {
        assert !_threads.isEmpty() : "Centrum obsugi jest zamknite";

        _calls.enqueue(call);

        System.out.println(call + " umieszczone w kolejce");
    }



    public void close() {
        assert !_threads.isEmpty() : "Centrum obsugi jest ju zamknite";

        System.out.println("Zamykanie centrum obsugi");

        // wysanie "zgoszenia koczcego" do kadego z agentw
        for (int i = 0; i < _numberOfAgents; ++i) {
            accept(CustomerServiceAgent.GO_HOME); 
        }

        Iterator i = _threads.iterator();
        for (i.first(); !i.isDone(); i.next()) {
            waitForTermination((Thread) i.current());
        }

        _threads.clear();

        System.out.println("Centrum obsugi jest zamknite");
    }


    private void waitForTermination(Thread thread) {
        try {
            thread.join();
        } catch (InterruptedException e) {
            // Ignoruj
        }
    }


}
