package com.wrox.algorithms.geometry;

public class Slope {
    private final double _wzniesienie;
    private final double _przesuniecie;

    public Slope(double wzniesienie, double przesuniecie) {
        _wzniesienie = wzniesienie;
        _przesuniecie = przesuniecie;
    }


    public boolean isVertical() {
        return _przesuniecie == 0;
    }


    public int hashCode() {
        return (int) (_wzniesienie * _przesuniecie);
    }


    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }

        if (object == null || object.getClass() != getClass()) {
            return false;
        }

        Slope other = (Slope) object;

        if (isVertical() && other.isVertical()) {
            return true;
        }

        if (isVertical() || other.isVertical()) {
            return false;
        }

        return (asDouble()) == (other.asDouble());
    }


    public double asDouble() {
        if (isVertical()) {
            throw new IllegalStateException(
                   "linia pionowa ma nachylenie nieskoczone");
        }

        return _wzniesienie / _przesuniecie;
    }





}
