package com.wrox.algorithms.iteration;

import junit.framework.TestCase;


public class EmptyIteratorTest extends TestCase {
    public void testForwardsIteration() {
        EmptyIterator iterator = EmptyIterator.INSTANCE;

        assertTrue(iterator.isDone());

        iterator.first();
        assertTrue(iterator.isDone());
        try {
            iterator.current();
            fail();
        } catch (IteratorOutOfBoundsException e) {
            
        }

        iterator.next();
        assertTrue(iterator.isDone());
        try {
            iterator.current();
            fail();
        } catch (IteratorOutOfBoundsException e) {
            
        }
    }

    public void testBackwardsIteration() {
        EmptyIterator iterator = EmptyIterator.INSTANCE;

        assertTrue(iterator.isDone());

        iterator.last();
        assertTrue(iterator.isDone());
        try {
            iterator.current();
            fail();
        } catch (IteratorOutOfBoundsException e) {
            
        }

        iterator.previous();
        assertTrue(iterator.isDone());
        try {
            iterator.current();
            fail();
        } catch (IteratorOutOfBoundsException e) {
            
        }
    }
}
