package com.wrox.algorithms.ssearch;

public class CallCountingCharSequence implements CharSequence {
    /** odnona sekwencja znakw */
    private final CharSequence _charSequence;

    /** licznik zliczajcy wywoania metody charAt() */
    private int _callCount;

    public CallCountingCharSequence(CharSequence charSequence) {
        assert charSequence != null : "nie okrelono sekwencji";
        _charSequence = charSequence;
    }

    public int getCallCount() {
        return _callCount;
    }

    public int length() {
        return _charSequence.length();
    }

    public char charAt(int index) {
        ++_callCount;
        return _charSequence.charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        return _charSequence.subSequence(start, end);
    }
}
