package com.wrox.algorithms.sorting;

import com.wrox.algorithms.iteration.Iterator;
import com.wrox.algorithms.lists.ArrayList;
import com.wrox.algorithms.lists.List;

public class CompoundComparator implements Comparator {
    /** lista komparatorw czstkowych */
    private final List _comparators = new ArrayList();



   public void addComparator(Comparator comparator) {
        assert comparator != null : "nie okrelono komparatora";
        assert comparator != this : 
                              "komparator nie moe by wasnym komparatorem czstkowym";

        _comparators.add(comparator);
    }



    public int compare(Object left, Object right) throws ClassCastException {
        int result = 0;
        Iterator i = _comparators.iterator();

        for (i.first(); !i.isDone(); i.next()) {
            result = ((Comparator) i.current()).compare(left, right);
            if (result != 0) { // pierwszy niezerowy wynik - rozstrzygajcy
                break;
            }
        }

        return result;
    }




}
