package com.wrox.algorithms.queues;

public class SynchronizedQueue implements Queue {
    /** obiekt synchronizacyjny */
    private final Object _mutex = new Object();

    /** odnona kolejka */
    private final Queue _queue;

    public SynchronizedQueue(Queue queue) {
        assert queue != null : "nie okrelono kolejki";
        _queue = queue;
    }

    public void enqueue(Object value) {
        synchronized (_mutex) {
            _queue.enqueue(value);
        }
    }

    public Object dequeue() throws EmptyQueueException {
        synchronized (_mutex) {
            return _queue.dequeue();
        }
    }

    public void clear() {
        synchronized (_mutex) {
            _queue.clear();
        }
    }

    public int size() {
        synchronized (_mutex) {
            return _queue.size();
        }
    }

    public boolean isEmpty() {
        synchronized (_mutex) {
            return _queue.isEmpty();
        }
    }
}
