public class SortedListPriorityQueue implements Queue {
    /** lista przechowujca elementy */
    private final List _list;

    /** komparator wyznaczajcy porzdek (priorytet) elementw */
    private final Comparator _comparator;
   
   /**
     * Konstruktor
     * Parametr: komparator wyznaczajcy porzdek (priorytet) elementw
     */

    public SortedListPriorityQueue(Comparator comparator) {
        assert comparator != null : "nie okrelono komparatora";
        _comparator = comparator;
        _list = new LinkedList();
    }



    public void enqueue(Object value) {
        int pos = _list.size();
        while (pos > 0 && _comparator.compare(_list.get(pos - 1), value) > 0) {
            --pos;
        }
        _list.insert(pos, value);
    }


   public Object dequeue() throws EmptyQueueException {
        if (isEmpty()) {
            throw new EmptyQueueException();
        }
        return _list.delete(_list.size() - 1);
    }


   public void clear() {
        _list.clear();
    }

    public int size() {
        return _list.size();
    }

    public boolean isEmpty() {
        return _list.isEmpty();
    }




}
