public class CustomerServiceAgent implements Runnable {
    /** zgoszenie sygnalizujce konsultantowi, 
      *  e nastpnych zgosze ju nie bdzie 
      */
    public static final Call GO_HOME = new Call(-1, 0);

    /** identyfikator konsultanta */
    private final int _id;

    /** kolejka zgosze */
    private final Queue _calls;

    /**
     * Konstruktor.
     * parametry: identyfikator konsultanta, kolejka zgosze
     */
    public CustomerServiceAgent(int id, Queue calls) {
        assert calls != null : "Nie okrelono kolejki zgosze";
        _id = id;
        _calls = calls;
    }
    public String toString() {
        return "Konsultant " + _id;
    }


    public void run() {
        System.out.println(this + " obecny");

        while (true) {
            System.out.println(this + " oczekuje");

            Call call = (Call) _calls.dequeue();
            System.out.println(this + " obsuguje " + call);

            if (call == GO_HOME) {
                break;
            }

            call.answer();
        }

        System.out.println(this + " zakoczy prac");
    }





}
