package com.wrox.algorithms.queues;

public class Call {
    /** identyfikator zgoszenia */
    private final int _id;

    /** czas trwania obsugi zgoszenia */
    private final int _duration;

    /** czas wygenerowania zgoszenia */
    private final long _startTime;

    /**
     * Konstruktor.
     * parametry: identyfikator zgoszenia, czas trwania obsugi zgoszenia
     */
    public Call(int id, int duration) {
        assert duration >= 0 : "czas obsugi nie moe by ujemny";

        _id = id;
        _duration = duration;
        _startTime = System.currentTimeMillis();
    }
    public String toString() {
        return "Zgoszenie " + _id;
    }



    public void answer() {
        System.out.println(this + " rozpoczcie obsugi po oczekiwaniu " 
                                + (System.currentTimeMillis() - _startTime) 
                                + " milisekund");

        try {
            Thread.sleep(_duration);
        } catch (InterruptedException e) {
            // Ignoruj
        }
    }




}
